/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;

@AutoSaveState
public class PoliciesManagementState
extends TaskletListState {
    private static final long serialVersionUID = 20130222L;
    private String defaultPolicyId;

    public PoliciesManagementState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Manage Policies");
    }

    public PoliciesManagementState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Policies");
    }

    @Override
    public void populate(Object dataFromDisk) {
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        OpenIdConnectProviderPolicy policy = connectProviderPolicyManager.getPolicy();
        OpenIdConnectProviderPolicy.PolicyGroup defaultPolicyGroup = policy.getDefaultPolicyGroup();
        this.defaultPolicyId = defaultPolicyGroup == null ? null : defaultPolicyGroup.getPolicyId();
        this.deleteAllTasklets();
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policy.getPolicyGroups().values()) {
            PolicyManagementTasklet policyManagementTasklet = this.createTasklet(PolicyManagementTasklet.class);
            policyManagementTasklet.setMode(Mode.edit);
            policyManagementTasklet.populate(policyGroup);
            policyManagementTasklet.setFinishLabel("Save");
            this.addTasklet(policyManagementTasklet);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        if (!this.isDefaultDefined()) {
            delegate.record(this.getMessage("Default_required"), ValidationConstraint.REQUIRED);
        }
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            PolicyManagementTasklet tasklet = (PolicyManagementTasklet)t;
            if (tasklet.isItDeleted()) continue;
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record(tasklet.getPolicyId() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }

    private boolean isDefaultDefined() {
        int size = 0;
        for (Tasklet t : this.getTasklets()) {
            PolicyManagementTasklet policyManagementTasklet = (PolicyManagementTasklet)t;
            if (policyManagementTasklet.isItDeleted()) continue;
            ++size;
            if (!StringUtils.equals((String)policyManagementTasklet.getPolicyId(), (String)this.defaultPolicyId)) continue;
            return true;
        }
        return size == 0;
    }

    public void delete(String policyToDelete) {
        boolean reloadList = false;
        for (Tasklet tasklet : this.getTasklets()) {
            PolicyManagementTasklet t = (PolicyManagementTasklet)tasklet;
            if (!StringUtils.equals((String)t.getPolicyId(), (String)policyToDelete)) continue;
            t.setItDeleted(true);
            OpenIdConnectProviderPolicyManager connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
            OpenIdConnectProviderPolicy connectProviderPolicy = connectProviderPolicyManager.getPolicy();
            connectProviderPolicy.deletePolicyGroup(t.getPolicy().getPolicyId());
            connectProviderPolicyManager.deletePolicy(connectProviderPolicy);
            if (connectProviderPolicy.getPolicyGroups() == null || connectProviderPolicy.getPolicyGroups().size() != 1) break;
            reloadList = true;
            break;
        }
        if (reloadList) {
            this.populate(null);
        }
    }

    public void undelete(String policyToUnDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            PolicyManagementTasklet t = (PolicyManagementTasklet)tasklet;
            if (!StringUtils.equals((String)t.getPolicyId(), (String)policyToUnDelete)) continue;
            t.setItDeleted(false);
            t.setOperation(PolicyManagementTasklet.Operation.NONE);
            return;
        }
    }

    public void setDefaultPolicy(String policyId) {
        this.defaultPolicyId = policyId;
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        connectProviderPolicyManager.setDefaultInstance(this.defaultPolicyId);
        OpenIdConnectProviderPolicy connectProviderPolicy = connectProviderPolicyManager.getPolicy();
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this.getParent());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)connectProviderPolicy, DependencyType.OAUTH_CLIENT_SETTINGS);
    }

    public boolean isDefaultPolicy(String policyId) {
        return StringUtils.equals((String)this.defaultPolicyId, (String)policyId);
    }

    public String getDefaultPolicyId() {
        return this.defaultPolicyId;
    }

    public Tasklet getTaskletFromList(String policyId) {
        for (Tasklet tasklet : this.getTasklets()) {
            PolicyManagementTasklet t = (PolicyManagementTasklet)tasklet;
            if (!StringUtils.equals((String)t.getPolicyId(), (String)policyId)) continue;
            return tasklet;
        }
        return null;
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        super.setTaskletToEdit(taskletToEdit);
        if (this.getPolicyList().size() == 1) {
            PolicyManagementTasklet tasklet = (PolicyManagementTasklet)this.getPolicyList().get(0);
            this.setDefaultPolicy(tasklet.getPolicyId());
        }
    }

    public List<Tasklet> getPolicyList() {
        return this.getTasklets();
    }

    public boolean isDefaultPolicyAndMoreThanOnePolicy(String policyId) {
        boolean moreThanOnePolicy;
        boolean bl = moreThanOnePolicy = this.getTasklets().size() > 1;
        return this.isDefaultPolicy(policyId) && moreThanOnePolicy;
    }
}

