/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.Arrays;
import java.util.List;

public class PolicyBranchUtil {
    private static final List<AsActionOption.Type> VALID_AUTH_SOURCE_TYPES = Arrays.asList(AsActionOption.Type.CONNECTION, AsActionOption.Type.ADAPTER, AsActionOption.Type.FRAGMENT);
    protected final Tree.Node<AsUiAction> node;

    public PolicyBranchUtil(Tree.Node<AsUiAction> node) {
        this.node = node;
    }

    public boolean isNodeAuthSourceSuccessBranch() {
        return this.isNodeAuthSourceSuccessBranch(this.node);
    }

    private boolean isNodeAuthSourceSuccessBranch(Tree.Node<AsUiAction> currentNode) {
        if (currentNode != null && currentNode.getData() != null) {
            AsUiAction uiAction = (AsUiAction)currentNode.getData();
            if (uiAction.getResultContext() == null || currentNode.getParent() == null) {
                return false;
            }
            if ("Fail".equals(uiAction.getResultContext())) {
                return false;
            }
            Tree.Node parentNode = currentNode.getParent();
            if (parentNode != null && ((AsUiAction)parentNode.getData()).getSelectedOption() != null && !VALID_AUTH_SOURCE_TYPES.contains((Object)((AsUiAction)parentNode.getData()).getSelectedOption().getType())) {
                return false;
            }
            AttributeRule rule = this.findMatchingRule(currentNode);
            return rule == null || !"policy.action".equals(rule.getAttribute());
        }
        return false;
    }

    public boolean isSuccessPath() {
        return this.isSuccessPath(this.node);
    }

    private boolean isSuccessPath(Tree.Node<AsUiAction> currentNode) {
        if (currentNode == null) {
            return false;
        }
        if (this.isNodeAuthSourceSuccessBranch(currentNode)) {
            return true;
        }
        return this.isSuccessPath((Tree.Node<AsUiAction>)currentNode.getParent());
    }

    protected AttributeRule findMatchingRule(Tree.Node<AsUiAction> currentNode) {
        List<AttributeRule> rules;
        if (currentNode != null && currentNode.getParent() != null && (rules = ((AsUiAction)currentNode.getParent().getData()).getAttributeRules()) != null) {
            for (AttributeRule rule : rules) {
                if (currentNode.getData() == null || !rule.getResult().equals(((AsUiAction)currentNode.getData()).getResultContext())) continue;
                return rule;
            }
        }
        return null;
    }
}

