/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.util.SAML2MappingModel;
import java.util.List;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrMapping;

public class PolicyContractMappingState
extends MappingState {
    private static final long serialVersionUID = 1L;

    public PolicyContractMappingState(Tasklet value, String name) {
        super(value, name);
        this.model.setTargetName("Attribute Contract");
        this.setMenuName("Contract Fulfillment");
    }

    @Override
    public void populate(Object dataFromDisk) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)dataFromDisk;
        this.attributeMapping = policyGroup.getUserInfoAttributeMapping();
        this.model = new SAML2MappingModel("Attribute Contract", this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)dataToDisk;
        UserInfoAttrMapping userInfoAttributeMapping = policyGroup.getUserInfoAttributeMapping();
        userInfoAttributeMapping.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        return true;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        PolicyManagementTasklet tasklet = this.findParent(PolicyManagementTasklet.class);
        tasklet.addStandardSourcesToPropertySelectionSources(this.sources);
    }

    public List<String> getTarget() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }
}

