/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.OpenIdConnectPolicyValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.impl.Wizard;
import com.pingidentity.fsm.state.impl.PoliciesManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PolicyManagementState
extends TaskletState {
    private static final long serialVersionUID = 20130222L;
    private static final String DEFAULT_ID_TOKEN_LIFE = "5";
    private String id;
    private String name;
    private String accessTokenManagerId;
    private String idTokenLife = "5";
    private boolean includeSriInIdToken;
    private boolean includeUserInfoInIdToken;
    private boolean includeSHashInIdToken;
    private boolean includeX5tInIdToken;
    private String idTokenTypHeaderValue;
    private boolean returnIdTokenOnRefreshGrant;
    private boolean returnIdTokenOnTokenExchangeGrant;
    private boolean reIssueIdTokenInHybridFlow;
    private boolean allowIdTokenIntrospection;
    private StringPairPropertySelectionModel tokenManagerIdList;

    public PolicyManagementState(IWizard owner, String name) {
        super(owner, name);
        this.setMenuName("Manage Policy");
        this.createTokenManagerIdList();
    }

    public PolicyManagementState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Policy");
        this.createTokenManagerIdList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)dataFromDisk;
            this.id = policyGroup.getPolicyId();
            this.name = policyGroup.getName();
            this.idTokenLife = String.valueOf(policyGroup.getIdTokenLife());
            this.includeSriInIdToken = policyGroup.isIncludeSriInIdToken();
            this.includeUserInfoInIdToken = policyGroup.isIncludeUserInfoInIdToken();
            this.includeSHashInIdToken = policyGroup.isIncludeSHashInIdToken();
            this.includeX5tInIdToken = policyGroup.isIncludeX5tInIdToken();
            this.idTokenTypHeaderValue = policyGroup.getIdTokenTypHeaderValue();
            this.returnIdTokenOnRefreshGrant = policyGroup.isReturnIdTokenOnRefreshGrant();
            this.returnIdTokenOnTokenExchangeGrant = policyGroup.isReturnIdTokenOnTokenExchangeGrant();
            this.reIssueIdTokenInHybridFlow = policyGroup.isReissueIdTokenHybridFlows();
            this.allowIdTokenIntrospection = policyGroup.isAllowIdTokenIntrospection();
            this.accessTokenManagerId = policyGroup.getAccessTokenManagerId();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        OpenIdConnectProviderPolicy.PolicyGroup policy = (OpenIdConnectProviderPolicy.PolicyGroup)dataToDisk;
        this.fillDomain(policy);
        PoliciesManagementState policiesManagementState = Optional.of(this.getParent()).map(Tasklet::getParentTasklet).map(Wizard::getCurrentState).filter(iWizardState -> iWizardState instanceof PoliciesManagementState).map(iWizardState -> (PoliciesManagementState)iWizardState).orElse(null);
        if (policiesManagementState != null && StringUtils.isBlank((String)policiesManagementState.getDefaultPolicyId())) {
            policiesManagementState.setDefaultPolicy(policy.getPolicyId());
        }
        policy.setLastModified((Calendar)new XmlCalendar(new Date()));
        return true;
    }

    private void fillDomain(OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        policyGroup.setPolicyId(this.id);
        policyGroup.setName(this.name);
        if (StringUtils.isBlank((String)this.idTokenLife)) {
            this.idTokenLife = DEFAULT_ID_TOKEN_LIFE;
        }
        try {
            policyGroup.setIdTokenLife(Integer.parseInt(this.idTokenLife));
        }
        catch (NumberFormatException e) {
            this.idTokenLife = DEFAULT_ID_TOKEN_LIFE;
            policyGroup.setIdTokenLife(Integer.parseInt(DEFAULT_ID_TOKEN_LIFE));
        }
        policyGroup.setIncludeSriInIdToken(this.includeSriInIdToken);
        policyGroup.setAccessTokenManagerId(this.accessTokenManagerId);
        policyGroup.setIncludeUserInfoInIdToken(this.includeUserInfoInIdToken);
        policyGroup.setReturnIdTokenOnRefreshGrant(this.returnIdTokenOnRefreshGrant);
        policyGroup.setReturnIdTokenOnTokenExchangeGrant(this.returnIdTokenOnTokenExchangeGrant);
        policyGroup.setReissueIdTokenHybridFlows(this.reIssueIdTokenInHybridFlow);
        policyGroup.setAllowIdTokenIntrospection(this.allowIdTokenIntrospection);
        policyGroup.setIncludeSHashInIdToken(this.includeSHashInIdToken);
        policyGroup.setIncludeX5tInIdToken(this.includeX5tInIdToken);
        policyGroup.setIdTokenTypHeaderValue(this.idTokenTypHeaderValue);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        OpenIdConnectPolicyValidator validator = new OpenIdConnectPolicyValidator(this.id, this.name, this.accessTokenManagerId, this.idTokenLife, this.idTokenTypHeaderValue, this.isCreateMode());
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Policy ID", this.getId(), this));
        summaryList.add(new SummaryInfo("Policy Name", this.getName(), this));
        summaryList.add(new SummaryInfo("Access Token Manager", this.getTokenManagerName(), this));
        summaryList.add(new SummaryInfo("ID Token Lifetime", this.getIdTokenLife(), this));
        summaryList.add(new SummaryInfo("Include Session Identifier in ID Token", Boolean.toString(this.isIncludeSriInIdToken()), this));
        summaryList.add(new SummaryInfo("Include User Info in ID Token", Boolean.toString(this.isIncludeUserInfoInIdToken()), this));
        summaryList.add(new SummaryInfo("Include State Hash in ID Token", Boolean.toString(this.isIncludeSHashInIdToken()), this));
        summaryList.add(new SummaryInfo("Include X.509 thumbprint header in ID Token", Boolean.toString(this.isIncludeX5tInIdToken()), this));
        summaryList.add(new SummaryInfo("ID Token Type (typ) Header Value", this.getIdTokenTypHeaderValue(), this));
        summaryList.add(new SummaryInfo("Return ID Token on Refresh Grant", Boolean.toString(this.isReturnIdTokenOnRefreshGrant()), this));
        summaryList.add(new SummaryInfo("Return ID Token on Token Exchange Grant", Boolean.toString(this.isReturnIdTokenOnTokenExchangeGrant()), this));
        summaryList.add(new SummaryInfo("Reissue ID Token during Hybrid Flow", Boolean.toString(this.isReIssueIdTokenInHybridFlow()), this));
        summaryList.add(new SummaryInfo("Allow ID Token Introspection", Boolean.toString(this.isAllowIdTokenIntrospection()), this));
    }

    public boolean isCreateMode() {
        Tasklet t = this.getParent();
        return t.getMode() == Mode.create;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getIdTokenLife() {
        return this.idTokenLife;
    }

    public void setIdTokenLife(String idTokenLife) {
        this.idTokenLife = idTokenLife;
    }

    public boolean isIncludeSriInIdToken() {
        return this.includeSriInIdToken;
    }

    public void setIncludeSriInIdToken(boolean include) {
        this.includeSriInIdToken = include;
    }

    public String getAccessTokenManagerId() {
        return this.accessTokenManagerId;
    }

    public void setAccessTokenManagerId(String accessTokenManagerId) {
        this.accessTokenManagerId = accessTokenManagerId;
    }

    public StringPairPropertySelectionModel getTokenManagerIdList() {
        return this.tokenManagerIdList;
    }

    public void setTokenManagerIdList(StringPairPropertySelectionModel tokenManagerIdList) {
        this.tokenManagerIdList = tokenManagerIdList;
    }

    public void createTokenManagerIdList() {
        this.tokenManagerIdList = new StringPairPropertySelectionModel(true);
        Collection instances = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances();
        for (BearerAccessTokenMgmtPluginInstance instance : instances) {
            this.tokenManagerIdList.add(instance.getName(), instance.getId());
        }
        this.tokenManagerIdList.sort();
    }

    @Override
    public void refreshState() {
        super.refreshState();
        this.createTokenManagerIdList();
    }

    private String getTokenManagerName() {
        if (this.accessTokenManagerId == null) {
            return "";
        }
        BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(this.accessTokenManagerId);
        if (instance == null) {
            return "";
        }
        return instance.getName();
    }

    public boolean isIncludeUserInfoInIdToken() {
        return this.includeUserInfoInIdToken;
    }

    public void setIncludeUserInfoInIdToken(boolean includeUserInfoInIdToken) {
        this.includeUserInfoInIdToken = includeUserInfoInIdToken;
    }

    public boolean isIncludeSHashInIdToken() {
        return this.includeSHashInIdToken;
    }

    public void setIncludeSHashInIdToken(boolean includeSHashInIdToken) {
        this.includeSHashInIdToken = includeSHashInIdToken;
    }

    public boolean isIncludeX5tInIdToken() {
        return this.includeX5tInIdToken;
    }

    public void setIncludeX5tInIdToken(boolean includeX5tInIdToken) {
        this.includeX5tInIdToken = includeX5tInIdToken;
    }

    public String getIdTokenTypHeaderValue() {
        return this.idTokenTypHeaderValue;
    }

    public void setIdTokenTypHeaderValue(String idTokenTypHeaderValue) {
        this.idTokenTypHeaderValue = idTokenTypHeaderValue;
    }

    public boolean isReturnIdTokenOnRefreshGrant() {
        return this.returnIdTokenOnRefreshGrant;
    }

    public void setReturnIdTokenOnRefreshGrant(boolean returnIdTokenOnRefreshGrant) {
        this.returnIdTokenOnRefreshGrant = returnIdTokenOnRefreshGrant;
    }

    public boolean isReturnIdTokenOnTokenExchangeGrant() {
        return this.returnIdTokenOnTokenExchangeGrant;
    }

    public void setReturnIdTokenOnTokenExchangeGrant(boolean returnIdTokenOnTokenExchangeGrant) {
        this.returnIdTokenOnTokenExchangeGrant = returnIdTokenOnTokenExchangeGrant;
    }

    public boolean isReIssueIdTokenInHybridFlow() {
        return this.reIssueIdTokenInHybridFlow;
    }

    public void setReIssueIdTokenInHybridFlow(boolean reIssueIdTokenInHybridFlow) {
        this.reIssueIdTokenInHybridFlow = reIssueIdTokenInHybridFlow;
    }

    public boolean isAllowIdTokenIntrospection() {
        return this.allowIdTokenIntrospection;
    }

    public void setAllowIdTokenIntrospection(boolean allowIdTokenIntrospection) {
        this.allowIdTokenIntrospection = allowIdTokenIntrospection;
    }

    public boolean isShowAccessTokenManagerButton() {
        return MgmtFactory.getAuthzServerManager().isEnableOAuth();
    }
}

