/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AttributeScopesState;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.CreatePolicyContractState;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.state.impl.PolicyAttributeSourcesState;
import com.pingidentity.fsm.state.impl.PolicyContractMappingState;
import com.pingidentity.fsm.state.impl.PolicyManagementState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.issuancecriteria.impl.PolicyIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PolicyManagementTasklet
extends MappingTasklet
implements AttributeNamesApi {
    private static final long serialVersionUID = 20130222L;
    private transient AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private Operation operation = Operation.NONE;
    private PolicyManagementState policyManagementState;
    private CreatePolicyContractState createPolicyContractState;
    private AttributeScopesState attributeScopesState;
    private PolicyContractMappingState policyContractMappingState;
    private PolicyIssuanceCriteriaState policyIssuanceCriteriaState;
    private SummaryCardState summaryCardState;

    public PolicyManagementTasklet(Visit visit) {
        super("PolicyManagementTasklet", "Policy");
        this.setSystemVisit(visit);
        this.policyManagementState = new PolicyManagementState(this);
        this.createPolicyContractState = new CreatePolicyContractState(this);
        this.policyContractMappingState = new PolicyContractMappingState(this, "mapping");
        this.policyIssuanceCriteriaState = new PolicyIssuanceCriteriaState(this);
        this.attributeScopesState = new AttributeScopesState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.policyManagementState.addOutgoingTransition(this, this.createPolicyContractState);
        this.createPolicyContractState.addOutgoingTransition(this, this.attributeScopesState);
        this.attributeScopesState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.policyContractMappingState);
        this.policyContractMappingState.addOutgoingTransition(this, this.policyIssuanceCriteriaState);
        this.policyIssuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.policyManagementState);
        this.setCancelAvailable(true);
    }

    protected OpenIdConnectProviderPolicy.PolicyGroup getPolicy() {
        OpenIdConnectProviderPolicy.PolicyGroup policy = new OpenIdConnectProviderPolicy.PolicyGroup();
        this.save(policy);
        return policy;
    }

    @Override
    public void finish() {
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        OpenIdConnectProviderPolicy connectProviderPolicy = connectProviderPolicyManager.getPolicy();
        OpenIdConnectProviderPolicy.PolicyGroup newPolicyGroup = this.getPolicy();
        connectProviderPolicy.addPolicyGroup(newPolicyGroup);
        connectProviderPolicyManager.savePolicy(connectProviderPolicy, this.getOperation() == Operation.INSERT);
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)connectProviderPolicy, DependencyType.OAUTH_CLIENT_SETTINGS);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new PolicyAttributeSourcesState(this, "configAttributeSources");
    }

    @Override
    public String getContractTypeForDisplay() {
        return "Claims Contract";
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        String accessTokenManagerId = this.policyManagementState.getAccessTokenManagerId();
        if (accessTokenManagerId == null) {
            return null;
        }
        BearerAccessTokenMgmtPluginManager accessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        ConfigurablePluginInstance instance = accessTokenMgmtPluginMgr.getInstance(accessTokenManagerId);
        return instance;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.createPolicyContractState.getContract().getAllAttributeNames();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.createPolicyContractState.getContract().getAllAttrNamesSorted();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.createPolicyContractState.getContract().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.createPolicyContractState.getContract().getSortedMutableAttributeNames();
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        ConfigurablePluginInstance instance = this.getSelectedPlugin();
        ArrayList<String> srcNames = new ArrayList<String>();
        if (instance != null) {
            srcNames.addAll(instance.getAttributeContract().getSortedMutableAttributeNames());
        }
        sources.addPropertySelectionSource("Token", null, "Access Token", new StringPairPropertySelectionModel(true, srcNames));
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForOpenIdPolicy()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
        this.setPersistentGrantsParamsAsSource(this.authzServerManager, sources);
        OAuthMetadataUtil.setExtendedMetadataParamsAsSource(sources, this.getMappingModel().getMapping());
    }

    public String getPolicyId() {
        return this.policyManagementState.getId();
    }

    public String getName() {
        return this.policyManagementState.getName();
    }

    public String getIdTokenLife() {
        return this.policyManagementState.getIdTokenLife();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public String getNoteKeySuffix() {
        return "OIDC";
    }

    public void cleanAttributeMappings(Set<String> attributeContract) {
        this.policyContractMappingState.getModel().cleanMappings(attributeContract);
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.policyContractMappingState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.policyIssuanceCriteriaState.getIssuanceCriteriaList();
    }

    private void setPersistentGrantsParamsAsSource(AuthzServerManager authzServerManager, DataMap.Sources sources) {
        Set grantAttributeNames = authzServerManager.getKeyOnlyContract().getAllAttributeNames();
        grantAttributeNames.add("EXPIRES_AT");
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (String grantAttributeName : grantAttributeNames) {
            model.add(grantAttributeName, "persistentgrant." + grantAttributeName);
        }
        sources.addPropertySelectionSource("Persistent Grant", model);
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        NONE;

    }
}

