/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.helper.BridgeHelper;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.AffiliationItem;
import com.pingidentity.fsm.tasklet.data.ConnectionItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.ManageAffiliationsTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.pingone.PingOneAdminService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.MenuAuthUtil;
import org.sourceid.saml20.metadata.Role;

public class PortalMenuState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final int CONNS_TO_DISPLAY = 15;
    private int totalIdPConnections;
    private int totalSpConnections;
    private int totalSpAffiliations;
    private transient List<ConnectionItem> spConnections;
    private transient List<ConnectionItem> idpConnections;
    private transient List<AffiliationItem> affiliations;

    public PortalMenuState(Tasklet value) {
        super(value);
        this.setMenuName("Main");
    }

    @Override
    public boolean isShowNote() {
        return false;
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        this.setTaskletToEditToNull();
    }

    public String clearCachedValues() {
        this.idpConnections = null;
        this.spConnections = null;
        this.totalIdPConnections = 0;
        this.totalSpConnections = 0;
        return "";
    }

    public List<ConnectionItem> getIdpConnections() {
        if (this.idpConnections != null) {
            return this.idpConnections;
        }
        this.idpConnections = new ArrayList<ConnectionItem>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        List c = (List)connectionManager.getFilteredIdpConnections();
        this.totalIdPConnections = c.size();
        PortalMenuState.getNewestConnections(c, this.idpConnections);
        return this.idpConnections;
    }

    public List<ConnectionItem> getSpConnections() {
        if (this.spConnections != null) {
            return this.spConnections;
        }
        this.spConnections = new ArrayList<ConnectionItem>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        ArrayList c = (ArrayList)connectionManager.getFilteredSpConnections();
        this.totalSpConnections = c.size();
        PortalMenuState.getNewestConnections(c, this.spConnections);
        return this.spConnections;
    }

    public Collection<AffiliationItem> getSpAffiliations() {
        this.affiliations = new ArrayList<AffiliationItem>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        ArrayList a = (ArrayList)connectionManager.getAffiliations();
        this.totalSpAffiliations = a.size();
        PortalMenuState.getNewestAffiliations(a, this.affiliations);
        return this.affiliations;
    }

    private static void getNewestConnections(List<? extends ConnectionBase> allConnections, List<ConnectionItem> newestConnections) {
        List sorted = allConnections.parallelStream().sorted(ConnectionBase.COMPARE_BY_LAST_MODIFIED).collect(Collectors.toList());
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        for (int i = 0; i < sorted.size(); ++i) {
            ConnectionBase connection = (ConnectionBase)sorted.get(i);
            ConnectionItem connectionItem = new ConnectionItem(localSettings, connection);
            newestConnections.add(connectionItem);
            if (i >= 14) break;
        }
    }

    private static void getNewestAffiliations(List<? extends Affiliation> allAffiliations, List<AffiliationItem> newestAffiliations) {
        Collections.sort(allAffiliations, Affiliation.COMPARE_BY_LAST_MODIFIED);
        for (int i = 0; i < allAffiliations.size(); ++i) {
            Affiliation affiliation = allAffiliations.get(i);
            AffiliationItem affiliationItem = new AffiliationItem(affiliation);
            newestAffiliations.add(affiliationItem);
            if (i >= 14) break;
        }
    }

    public Tasklet getIdpTaskletFromList(String identifier) {
        for (ConnectionItem item : this.idpConnections) {
            if (!item.getEntityId().equals(identifier)) continue;
            Tasklet currentTasklet = (Tasklet)this.getWizard();
            IdpConnectionConfigTasklet tasklet = currentTasklet.createTaskletToLoad(IdpConnectionConfigTasklet.class);
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            IdpConnection connection = connectionManager.getIdpConnection(identifier);
            tasklet.setIdpConnection(connection);
            tasklet.setMode(Mode.edit);
            tasklet.populate(connection);
            return tasklet;
        }
        return null;
    }

    public Tasklet getSpTaskletFromList(String identifier) {
        for (ConnectionItem item : this.spConnections) {
            if (!item.getEntityId().equals(identifier)) continue;
            Tasklet currentTasklet = (Tasklet)this.getWizard();
            SpConnectionConfigTasklet tasklet = currentTasklet.createTaskletToLoad(SpConnectionConfigTasklet.class);
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            SpConnection spConnection = connectionManager.getSpConnection(identifier);
            tasklet.setSpConnection(spConnection);
            tasklet.setMode(Mode.edit);
            tasklet.populate(spConnection);
            return tasklet;
        }
        return null;
    }

    public Tasklet getAffiliationTaskletFromList(String identifier) {
        for (AffiliationItem item : this.affiliations) {
            if (!item.getAffiliationId().equals(identifier)) continue;
            Tasklet currentTasklet = (Tasklet)this.getWizard();
            ManageAffiliationsTasklet tasklet = currentTasklet.createTaskletToLoad(ManageAffiliationsTasklet.class);
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            Affiliation affiliation = connectionManager.getAffiliation(identifier);
            tasklet.setMode(Mode.edit);
            tasklet.populate(affiliation);
            return tasklet;
        }
        return null;
    }

    public int getIdpConnectionCount() {
        this.getIdpConnections();
        return this.totalIdPConnections;
    }

    public int getSpConnectionCount() {
        this.getSpConnections();
        return this.totalSpConnections;
    }

    public int getAffiliationCount() {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        return connectionManager.getSpAffiliationCount();
    }

    public boolean isShowAffiliations() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableSamlIdP();
    }

    public boolean isEnableSamlSpOrEnableSamlIdp() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableSamlSp() || localSettings.isEnableSamlIdP() || localSettings.isEnableSamlOneOneAp() || localSettings.isEnableSamlOneOneRp() || localSettings.isEnableSamlOneZeroAp() || localSettings.isEnableSamlOneZeroRp();
    }

    public boolean isEnableOpenIdConnectIdp() {
        OpenIdConnectProviderPolicyManager connectProviderPolicyMgr = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        return connectProviderPolicyMgr.getPolicy().isEnabled();
    }

    public boolean isEnableIdpDiscovery() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableIdpDiscovery();
    }

    public boolean isEnableInboundProvisioning() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableInboundProvisioning();
    }

    public boolean isCluster() {
        return !MgmtFactory.getMediator().isStandalone();
    }

    public boolean isCryptoVisible() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isCryptoManager() || user.isAuditor();
    }

    public boolean isAdminVisible() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return MenuAuthUtil.isAdminVisible((AdministrativeUser)user);
    }

    public boolean isShowSystemAppIntegration() {
        return this.isAdminVisible() && this.isEnableIdP() && this.isEnableSP();
    }

    public boolean isMetadataExportActive() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isAdmin();
    }

    public boolean isXMLFileSignaturesActive() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isAdmin() || user.isCryptoManager();
    }

    public boolean isConfigArchiveActive() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isAdmin();
    }

    public boolean isAuditor() {
        return this.getVisit().getCurrentUser().isAuditor();
    }

    public boolean isAdminManager() {
        return this.getVisit().getCurrentUser().isAdminManager();
    }

    public boolean isAcctManagementVisible() {
        AdministrativeUser user = this.getCurrentUser();
        return MenuAuthUtil.isAcctManagementVisible((AdministrativeUser)user);
    }

    public boolean isLicenseManagementVisible() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return MenuAuthUtil.isLicenseManagementVisible((AdministrativeUser)user);
    }

    public boolean isAttrRequesterMappingVisible() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableX509Discovery();
    }

    public boolean isAdminFunctionsVisible() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return MenuAuthUtil.isAdminFunctionsVisible((AdministrativeUser)user);
    }

    public boolean isAdvancedFedSettingsVisible() {
        return this.isAdminVisible() && (this.isShowSystemAppIntegration() || this.isToken2TokenVisible());
    }

    public boolean isConnectToPingOneVisible() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return user.isAdmin() && localSettings.isEnableIdP() && !this.isPingOneAssociated();
    }

    public boolean isPingOneAssociated() {
        return MgmtFactory.getPingOneAdminService().isAssociated();
    }

    public String getSpWhiteListStyle() {
        return "";
    }

    public String getIdpWhiteListStyle() {
        return "";
    }

    public String getIdpConfigurationWidth() {
        return PortalMenuState.getRoleWidth(this.isEnableSP());
    }

    public String getSpConfigurationWidth() {
        return PortalMenuState.getRoleWidth(this.isEnableIdP());
    }

    private static String getRoleWidth(boolean condition) {
        return condition ? "25%" : "50%";
    }

    public String getMySettingsWidth() {
        return this.getMySettingsSubWidth() + "%";
    }

    public String getMySettingsFullWidth() {
        return this.getMySettingsSubWidth() * 2 + "%";
    }

    private int getMySettingsSubWidth() {
        int width = 50;
        if (this.isEnableIdP() || this.isEnableSP()) {
            width = 25;
        }
        return width;
    }

    public boolean isIdpWsTrustEnabled() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableWsTrustIdP() || MgmtFactory.getConnectionManager().isWsTrustStsInUse(Role.SP);
    }

    public boolean isSpWsTrustEnabled() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableWsTrustSp() || MgmtFactory.getConnectionManager().isWsTrustStsInUse(Role.IDP);
    }

    public boolean isToken2TokenVisible() {
        return this.isIdpWsTrustEnabled() && this.isSpWsTrustEnabled();
    }

    public boolean isAdmin() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isAdmin();
    }

    public boolean isCryptoAdmin() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return user.isCryptoManager();
    }

    public boolean isAuthorizedForConfigurationArchiveManagement() {
        AdministrativeUser user = this.getVisit().getCurrentUser();
        return MenuAuthUtil.isAuthorizedForConfigurationArchiveManagement((AdministrativeUser)user);
    }

    public boolean isPingOneSSOConfigured() {
        return BridgeHelper.getInstance().isPingOneSSOConfigured();
    }

    public boolean isPingIDConfigured() {
        return BridgeHelper.getInstance().isPingIDConfigured();
    }

    public String getPingOneApplicationURL() {
        PingOneAdminService adminService = MgmtFactory.getPingOneAdminService();
        return adminService.getMetadata().getAddApplicationUrl();
    }
}

