/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CibaPolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.RequestHintContractMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.plugins.RequestTypeMappingModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceType;

public class RequestHintContractFulfillmentMappingState
extends MappingState
implements Serializable {
    public RequestHintContractFulfillmentMappingState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Identity Hint Contract Fulfillment Mapping");
        this.model = new RequestTypeMappingModel("Contract", null, this.getCurrentUser());
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.attributeMapping = ((CibaServerPolicy.RequestHandlingPolicy)dataFromDisk).getEnhanceRequestHintContractMapping();
        this.model = new RequestTypeMappingModel("Contract", this.attributeMapping, this.getCurrentUser());
        this.updateAttributeMapping();
        this.setDefaultMappingType();
    }

    private void updateAttributeMapping() {
        if (this.model.getMapping() != null) {
            Collection targetAttributes = this.getTarget();
            Set existingAttributes = this.model.getMapping().getAttributeMapping().keySet();
            for (String targetAttribute : targetAttributes) {
                if (existingAttributes.contains(targetAttribute)) continue;
                ArrayList<AttrMappingValue> attrMappingValueList = new ArrayList<AttrMappingValue>();
                attrMappingValueList.add(new AttrMappingValue(SourceType.REQUEST, targetAttribute));
                this.model.getMapping().getAttributeMapping().put(targetAttribute, attrMappingValueList);
            }
            HashSet<String> removeTheseAttributes = new HashSet<String>();
            for (String existingAttribute : existingAttributes) {
                if (targetAttributes.contains(existingAttribute)) continue;
                removeTheseAttributes.add(existingAttribute);
            }
            for (String removeThisAttribute : removeTheseAttributes) {
                this.model.getMapping().getAttributeMapping().remove(removeThisAttribute);
            }
        }
    }

    private void setDefaultMappingType() {
        if (this.model.getMapping() != null) {
            if (!this.model.getMapping().getAttributeMapping().isEmpty()) {
                Map map = this.model.getMapping().getAttributeMapping();
                for (Map.Entry e : map.entrySet()) {
                    for (AttrMappingValue attrMappingValue : (List)e.getValue()) {
                        if (attrMappingValue.getType() == null || !attrMappingValue.getType().equals((Object)SourceType.REQUEST)) continue;
                        attrMappingValue.setValue((String)e.getKey());
                    }
                }
            } else {
                HashMap attributeMap = new HashMap();
                for (String attributeName : this.getTarget()) {
                    ArrayList<AttrMappingValue> attrMappingValueList = new ArrayList<AttrMappingValue>();
                    attrMappingValueList.add(new AttrMappingValue(SourceType.REQUEST, attributeName));
                    attributeMap.put(attributeName, attrMappingValueList);
                }
                this.model.getMapping().setAttributeMap2(attributeMap);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (((CibaServerPolicy.RequestHandlingPolicy)dataToDisk).getEnhanceRequestHintContractMapping() != null) {
            AttributeMapping attributeMapping = ((CibaServerPolicy.RequestHandlingPolicy)dataToDisk).getEnhanceRequestHintContractMapping();
            attributeMapping.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        }
        return true;
    }

    public Set<String> getTarget() {
        CibaPolicyManagementTasklet parentTasklet = this.findParent(CibaPolicyManagementTasklet.class);
        return new HashSet<String>(parentTasklet.getAllRequestHintAttrNamesSorted());
    }

    @Override
    public RequestTypeMappingModel getModel() {
        return (RequestTypeMappingModel)super.getModel();
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        RequestHintContractMappingTasklet tasklet = this.findParent(RequestHintContractMappingTasklet.class);
        tasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
        this.setDefaultMappingType();
    }

    @Override
    public boolean onStateExit() {
        this.updateAttributeMapping();
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        this.updateAttributeMapping();
        super.doSummary(summaryList);
    }
}

