/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.google.common.collect.Sets;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.CibaPolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.RequestHintContractAttributeSourcesState;
import com.pingidentity.fsm.state.impl.RequestHintContractFulfillmentMappingState;
import com.pingidentity.fsm.state.impl.RequestHintContractIssuanceCriteriaState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.plugins.RequestTypeMappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;

public class RequestHintContractMappingTasklet
extends MappingTasklet
implements AttributeNamesApi {
    private static final long serialVersionUID = 1L;
    private final RequestHintContractFulfillmentMappingState mappingFulfillmentState;
    private final RequestHintContractIssuanceCriteriaState issuanceCriteriaState;
    private final SummaryCardState summaryCardState;
    private transient CibaServerPolicy.RequestHandlingPolicy sourcePolicy;

    public RequestHintContractMappingTasklet(Visit visit) {
        super("RequestHintContractMappingTasklet", "Identity Hint Mapping");
        this.setSystemVisit(visit);
        this.mappingFulfillmentState = new RequestHintContractFulfillmentMappingState(this, "mapping");
        this.issuanceCriteriaState = new RequestHintContractIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.createTransitions();
        this.setInitialState(this.configAttributeSourcesState);
        this.setCancelAvailable(true);
    }

    private void createTransitions() {
        this.configAttributeSourcesState.addOutgoingTransition(this, this.mappingFulfillmentState);
        this.mappingFulfillmentState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return Sets.newHashSet(((CibaPolicyManagementTasklet)this.getParentTasklet()).getAllRequestHintAttrNamesSorted());
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.sortSet(this.getAllAttributeNames());
    }

    private List<String> sortSet(Set<String> stringset) {
        return ConfigurationUtil.sortSet(stringset);
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return null;
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return null;
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new RequestHintContractAttributeSourcesState(this, "configAttributeSources");
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        List<String> srcNames = this.getAllAttrNamesSorted();
        sources.addPropertySelectionSource("Request", new StringPairPropertySelectionModel(true, srcNames));
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : this.getContextMappingTypes()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForPluginContracts();
    }

    public Set<String> getTarget() {
        return this.mappingFulfillmentState.getTarget();
    }

    @Override
    public void finish() {
        CibaServerPolicy.RequestHandlingPolicy instance = new CibaServerPolicy.RequestHandlingPolicy();
        this.save(instance);
        this.setPopulateData(instance);
        super.finish();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.sourcePolicy = (CibaServerPolicy.RequestHandlingPolicy)dataFromDisk;
        super.populate(dataFromDisk);
    }

    private CibaServerPolicy.RequestHandlingPolicy getSourcePolicy() {
        return this.sourcePolicy;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions();
    }

    @Override
    public RequestTypeMappingModel getMappingModel() {
        return this.mappingFulfillmentState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.issuanceCriteriaState.getIssuanceCriteriaList();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public Collection<String> getAdditionalInputAttributesForFilter() {
        CibaPolicyManagementTasklet parentTasklet = this.findParent(CibaPolicyManagementTasklet.class);
        ArrayList<String> validValues = new ArrayList<String>();
        validValues.add("IDENTITY_HINT_SUBJECT");
        for (String hintContractAttribute : parentTasklet.getAllRequestHintAttributeNames()) {
            if (!hintContractAttribute.equals("login_hint") && !hintContractAttribute.startsWith("login_hint_token.") && !hintContractAttribute.startsWith("id_token_hint.") && !hintContractAttribute.startsWith("request.")) continue;
            validValues.add(hintContractAttribute);
        }
        return validValues;
    }
}

