/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AuthnSourceListApi;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConfigAdapterMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class SelectAdapterState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    protected ADAPTER_TYPE adapterType;
    protected transient AuthnAdapterInstance selectedAdapter;
    protected transient AuthnAdapterInstance connectionOverrideInstance;
    protected String selectedAdapterId;
    protected List<String> attributeList = new ArrayList<String>();
    protected boolean newAdapter = true;
    private boolean overrideAdapterConnectionSettings;

    public SelectAdapterState(Tasklet value) {
        super(value);
        this.setMenuName("Adapter Instance");
    }

    @Override
    public void initialize() {
        this.createAdapterAttributeList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof TargetAttributeMapping) {
            TargetAttributeMapping targetAttributeMapping = (TargetAttributeMapping)dataFromDisk;
            this.selectedAdapter = this.getAdapterById(targetAttributeMapping.getAdapterInstanceId());
            if (this.selectedAdapter != null) {
                this.selectedAdapterId = this.selectedAdapter.getId();
                this.connectionOverrideInstance = targetAttributeMapping.getConnectionOverrideInstance();
                this.setOverrideAdapterConnectionSettings(this.selectedAdapter.isConnectionBasedPlugin());
            }
            this.createAdapterAttributeList();
            this.getParent().reconfigureTransitions(this);
        } else if (dataFromDisk instanceof AdapterToAssertionMapping) {
            AdapterToAssertionMapping adapterToAssertionMapping = (AdapterToAssertionMapping)dataFromDisk;
            this.selectedAdapter = this.getAdapterById(adapterToAssertionMapping.getAdapterInstanceId());
            if (this.selectedAdapter != null) {
                this.selectedAdapterId = this.selectedAdapter.getId();
                this.connectionOverrideInstance = adapterToAssertionMapping.getConnectionOverrideInstance();
                this.setOverrideAdapterConnectionSettings(this.selectedAdapter.isConnectionBasedPlugin());
            }
            this.createAdapterAttributeList();
            this.getParent().reconfigureTransitions();
        }
        this.newAdapter = false;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof TargetAttributeMapping) {
            TargetAttributeMapping tempMapping = (TargetAttributeMapping)dataToDisk;
            tempMapping.setAdapterInstanceId(this.selectedAdapter.getId());
        } else if (dataToDisk instanceof AdapterToAssertionMapping) {
            AdapterToAssertionMapping tempMapping = (AdapterToAssertionMapping)dataToDisk;
            tempMapping.setAdapterInstanceId(this.selectedAdapter.getId());
        }
        return true;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void reset() {
        this.selectedAdapter = null;
        this.selectedAdapterId = null;
        this.attributeList = null;
        this.newAdapter = true;
    }

    @Override
    public void onResumeDraft() {
        if (this.selectedAdapter == null && this.selectedAdapterId != null) {
            this.selectedAdapter = this.getAdapterById(this.selectedAdapterId);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedAdapter == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("You_must_select_an_adapter"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
        this.selectedAdapter = this.getAdapterById(this.selectedAdapterId);
        this.createAdapterAttributeList();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.selectedAdapter != null) {
            if (this.isOverrideSettingUnchecked()) {
                Tasklet configTasklet = this.getParent();
                Object pluginManager = null;
                pluginManager = configTasklet instanceof SpConfigAdapterMappingTasklet ? MgmtFactory.getIdpAdapterManager() : MgmtFactory.getSpAdapterManager();
                AuthnAdapterInstance selectedAdapter = this.getSelectedAdapter();
                AuthnAdapterInstance parentAdapter = (AuthnAdapterInstance)pluginManager.getInstance(selectedAdapter.getParentId());
                this.setSelectedAdapter(parentAdapter);
                ((PluginMappingApi)((Object)configTasklet)).removeConnectionOverride();
            }
            this.createAdapterAttributeList();
        } else {
            this.attributeList = null;
        }
        if (this.getTaskletToEdit() != null) {
            this.setTaskletToEditToNull();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedAdapter != null) {
            summaryList.add(new SummaryInfo(this.getMessage("Selected_adapter"), this.selectedAdapter.getName(), this));
        }
    }

    @Override
    public String getNoteKey() {
        if (this.isNewAdapter()) {
            String id = this.getTaskletStateId() + "New";
            if (this.isOidc()) {
                id = id + "_Oidc";
                return id;
            }
            return id;
        }
        return super.getNoteKey();
    }

    protected AuthnAdapterInstance getAdapterById(String id) {
        AdapterManager adapterMgr = MgmtFactory.getAdapterManager();
        switch (this.adapterType) {
            case AUTHN: {
                for (AuthnAdapterInstance adapter : adapterMgr.getSpAuthnAdapterInstances()) {
                    if (!adapter.getId().equals(id)) continue;
                    return adapter;
                }
                break;
            }
            case IDP_AUTHN: {
                for (IdpAuthnAdapterInstance adapter : adapterMgr.getIdpAuthnAdapterInstances()) {
                    if (!adapter.getId().equals(id)) continue;
                    return adapter;
                }
                break;
            }
        }
        return null;
    }

    public void createAdapterAttributeList() {
        AuthnAdapterInstance instance = this.getSelectedAdapter();
        if (instance != null) {
            PluginMappingApi pluginMappingApi = (PluginMappingApi)((Object)this.getParent());
            if (pluginMappingApi.isOverridePluginPopulated()) {
                this.attributeList = pluginMappingApi.getPluginContract();
            } else {
                instance = pluginMappingApi.isOverridePluginConnectionSettings() && this.connectionOverrideInstance != null ? this.connectionOverrideInstance : this.getSelectedAdapter();
                AttributeContract contract = instance.getAttributeContract();
                this.selectedAdapterId = instance.getId();
                this.attributeList = new ArrayList<String>(contract.getAllAttributeNames());
                Collections.sort(this.attributeList, String.CASE_INSENSITIVE_ORDER);
            }
        }
    }

    public boolean isOverrideSettingUnchecked() {
        return !this.isOverrideAdapterConnectionSettings() && this.getSelectedAdapter() != null && this.getSelectedAdapter().isConnectionBasedPlugin();
    }

    public StringPairPropertySelectionModel getAdapterList() {
        return this.findParent(AuthnSourceListApi.class).getAdapterList();
    }

    public AuthnAdapterInstance getSelectedAdapter() {
        return this.selectedAdapter;
    }

    public void setSelectedAdapter(AuthnAdapterInstance selectedAdapter) {
        this.selectedAdapter = selectedAdapter;
        this.selectedAdapterId = selectedAdapter != null ? selectedAdapter.getId() : null;
    }

    public List<String> getAttributeList() {
        return this.attributeList;
    }

    public boolean isNewAdapter() {
        return this.newAdapter;
    }

    public void setNewAdapter(boolean newAdapter) {
        this.newAdapter = newAdapter;
    }

    public ADAPTER_TYPE getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterType(ADAPTER_TYPE adapterType) {
        this.adapterType = adapterType;
    }

    public boolean isAdapterIdpAuthn() {
        return this.adapterType == ADAPTER_TYPE.IDP_AUTHN;
    }

    public boolean isOverrideAdapterConnectionSettings() {
        return this.overrideAdapterConnectionSettings;
    }

    public void setOverrideAdapterConnectionSettings(boolean overrideAdapterConnectionSettings) {
        if (this.overrideAdapterConnectionSettings != overrideAdapterConnectionSettings) {
            PluginMappingApi parent = (PluginMappingApi)((Object)this.getParent());
            parent.removeConnectionOverride();
            this.overrideAdapterConnectionSettings = overrideAdapterConnectionSettings;
        }
    }

    public String getNonCBPOAdapterId() {
        if (!this.isNewAdapter() && this.overrideAdapterConnectionSettings && this.connectionOverrideInstance != null) {
            return this.connectionOverrideInstance.getParentId();
        }
        return this.selectedAdapterId;
    }

    public boolean isOidc() {
        return this.findParent(ConnectionTasklet.class).getProtocolType() == Protocol.OIDC;
    }

    public static enum ADAPTER_TYPE {
        IDP_AUTHN,
        AUTHN;

    }
}

