/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.websso.Protocol;

public class SelectAdditionalAttributesState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private List<String> contractList;
    protected static final String ADDITIONAL_ATTRIBUTES = "ADDITIONAL_ATTRIBUTES";
    protected static final String NO_ADDITIONAL_ATTRIBUTES = "NO_ADDITIONAL_ATTRIBUTES";
    protected String selectedRadioValue = "NO_ADDITIONAL_ATTRIBUTES";
    private boolean reconfigure = true;

    public SelectAdditionalAttributesState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Retrieval");
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
            this.getParent().reconfigureTransitions(this);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeMapping mapping = (AttributeMapping)dataFromDisk;
        AttributeSource source = mapping.getAttributeSource();
        this.setRadioValue(source);
        if (this.reconfigure) {
            this.reconfigure = false;
            this.getParent().reconfigureTransitions(this);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedRadioValue.equals(ADDITIONAL_ATTRIBUTES)) {
            summaryList.add(new SummaryInfo("Attribute location", "Use the " + this.getAssertionText() + " to lookup additional information", this));
        } else {
            summaryList.add(new SummaryInfo("Attribute location", "Use only the attributes available in the " + this.getAssertionText(), this));
        }
    }

    protected void setRadioValue(AttributeSource source) {
        this.selectedRadioValue = source != null && !DataSource.DSType.None.getName().equalsIgnoreCase(source.getType()) ? ADDITIONAL_ATTRIBUTES : NO_ADDITIONAL_ATTRIBUTES;
    }

    public boolean includeAdditionalAttributes() {
        return ADDITIONAL_ATTRIBUTES.equals(this.selectedRadioValue);
    }

    public String getSelectedRadioValue() {
        return this.selectedRadioValue;
    }

    public void setSelectedRadioValue(String selectedRadioValue) {
        if (!this.selectedRadioValue.equals(selectedRadioValue)) {
            this.selectedRadioValue = selectedRadioValue;
            this.getParent().reconfigureTransitions(this);
        }
    }

    public List<String> getContractList() {
        return this.contractList;
    }

    public void setContractList(List<String> contractList) {
        this.contractList = contractList;
    }

    @Override
    public String getNoteKey() {
        if (this.isOidc()) {
            return super.getNoteKey() + "_Oidc";
        }
        return super.getNoteKey();
    }

    public boolean isOidc() {
        ConnectionTasklet tasklet = this.findParent(ConnectionTasklet.class);
        if (tasklet != null) {
            return tasklet.getProtocolType() == Protocol.OIDC;
        }
        return false;
    }

    public String getAdditionalAttributesText() {
        return this.getMessage("Additional_attributes", new Object[]{this.getAssertionText()});
    }

    public String getNoAdditionalAttributesText() {
        return this.getMessage("No_additional_attributes", new Object[]{this.getAssertionText()});
    }

    private String getAssertionText() {
        String assertionText = this.isOidc() ? "provider claims" : "SSO Assertion";
        return assertionText;
    }
}

