/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.authncontext.AuthnContextClassRef;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;

public class SelectAuthnContextState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String selectedSamlAuthnContext = "- SELECT -";
    private StringPairPropertySelectionModel samlAuthnContextList;

    public SelectAuthnContextState(IWizard owner) {
        super(owner);
        this.setMenuName("Authentication Context");
    }

    @Override
    public void onStateActivated() {
        this.buildContextList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        AuthnAdapterInstance adapterInstance = (AuthnAdapterInstance)dataFromDisk;
        IdpAuthnAdapterInstance idpAdapterInstance = (IdpAuthnAdapterInstance)adapterInstance;
        if (adapterInstance != null) {
            this.selectedSamlAuthnContext = idpAdapterInstance.getAuthnCtxClassRef();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        AuthnAdapterInstance tempAdapterInstance = (AuthnAdapterInstance)dataToDisk;
        IdpAuthnAdapterInstance tempIdpAdapterInstance = (IdpAuthnAdapterInstance)tempAdapterInstance;
        tempIdpAdapterInstance.setAuthnCtxClassRef(this.selectedSamlAuthnContext);
        return true;
    }

    private void buildContextList() {
        this.samlAuthnContextList = new StringPairPropertySelectionModel();
        Class<AuthnContextClassRef> c = AuthnContextClassRef.class;
        Field[] fields = c.getFields();
        this.samlAuthnContextList.add("- SELECT -", "- SELECT -");
        for (int i = 0; i < Array.getLength(fields); ++i) {
            try {
                this.samlAuthnContextList.add(this.getShortName((String)fields[i].get(null)), fields[i].get(null));
                continue;
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)"An IllegalArgumentException was thrown trying to access the static fields of AuthnContextClassRef.class while trying to build a dropdown list.  You should never see this message!!");
                continue;
            }
            catch (IllegalAccessException accessEx) {
                this.log.error((Object)"An IllegalAccessException was thrown trying to access the static fields of AuthnContextClassRef.class while trying to build a dropdown list.  You should never see this message!!");
            }
        }
        this.samlAuthnContextList.sort();
    }

    private String getShortName(String urn) {
        String[] tokens = urn.split(":");
        return tokens[tokens.length - 1];
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.selectedSamlAuthnContext) || "- SELECT -".equals(this.selectedSamlAuthnContext)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Saml_authn_context_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Selected_context"), this.selectedSamlAuthnContext == null ? "None" : this.getShortName(this.getSelectedSamlAuthnContext()), this));
    }

    public StringPairPropertySelectionModel getSamlAuthnContextList() {
        return this.samlAuthnContextList;
    }

    public void setSamlAuthnContextList(StringPairPropertySelectionModel samlAuthnContextList) {
        this.samlAuthnContextList = samlAuthnContextList;
    }

    public String getSelectedSamlAuthnContext() {
        return this.selectedSamlAuthnContext;
    }

    public void setSelectedSamlAuthnContext(String selectedSamlAuthnContext) {
        this.selectedSamlAuthnContext = selectedSamlAuthnContext;
    }

    public String getSelectedSamlAuthnContextShortName() {
        return this.getShortName(this.selectedSamlAuthnContext);
    }
}

