/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;

public class SelectCertVerificationMethodState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private boolean anchored;

    public SelectCertVerificationMethodState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Certificate Verification Method");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connectionBase = (ConnectionBase)dataFromDisk;
        SoapAuthInfo soapAuthIn = connectionBase.getSoapAuthIn();
        this.anchored = soapAuthIn.getCertAuthInfo().isAnchored();
        if (this.anchored && soapAuthIn.getCertAuthInfo().getIssuerDN() == null && soapAuthIn.getCertAuthInfo().getSubjectDN() == null) {
            this.anchored = false;
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String description = this.anchored ? "Anchored" : "Unanchored";
        summaryList.add(new SummaryInfo(this.getMessage("Method"), description, this));
    }

    public String getSelected() {
        return String.valueOf(this.anchored);
    }

    public boolean isAnchored() {
        return this.anchored;
    }

    public void setSelected(String selected) {
        this.anchored = Boolean.parseBoolean(selected);
    }

    @Override
    public void reset() {
        this.anchored = false;
    }
}

