/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.RetrieveAttributeSourceInstance;
import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAttributeSourceTasklet;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SelectCustomSourceFieldsState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private transient CustomDataSource customSource;
    private CheckboxModel checkboxModel = new CheckboxModel();
    private boolean resumeDraft;

    public SelectCustomSourceFieldsState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Configure Data Source Fields");
    }

    public SelectCustomSourceFieldsState(IWizard owner) {
        super(owner);
        this.setMenuName("Configure Data Source Fields");
    }

    @Override
    public void onStateActivated() {
        RetrieveAttributeSourceInstance parent = this.findParent(RetrieveAttributeSourceInstance.class);
        if (parent != null && this.customSource == null) {
            this.customSource = parent.getSelectedCustomDataSource();
            if (this.customSource.getDriver() == null) {
                DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                dsMgr.loadCustomDataSourceDriver(this.customSource);
            }
            this.initialize(null, null);
        } else {
            this.loadCheckboxModel(null, null);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeMapping attributeMapping = (AttributeMapping)dataFromDisk;
        AttributeSource attributeSource = attributeMapping.getAttributeSource();
        if (attributeSource != null) {
            this.customSource = (CustomDataSource)attributeSource.getDataSource();
        }
        if (this.customSource.getDriver() == null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            dsMgr.loadCustomDataSourceDriver(this.customSource);
        }
        this.initialize(attributeMapping.getAttributeMap(), attributeMapping.getTokenAuthorizationIssuanceCriteria());
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        List<String> selectedFields = this.getSelectedFields();
        if (selectedFields != null) {
            for (String selectedField : selectedFields) {
                summaryList.add(new SummaryInfo("Field", selectedField, this));
            }
        }
    }

    protected void initialize(Map<String, AttrMappingValue> attrMap, List<TokenAuthorizationIssuanceCriterion> criteria) {
        if (this.resumeDraft) {
            return;
        }
        if (this.checkboxModel != null) {
            this.checkboxModel.clear();
        }
        this.loadCheckboxModel(attrMap, criteria);
    }

    private void loadCheckboxModel(Map<String, AttrMappingValue> attrMap, List<TokenAuthorizationIssuanceCriterion> criteria) {
        Set<String> attributeSourceFilterReferences;
        List allNames = this.customSource.getDriver().getAvailableFields();
        if (this.checkboxModel.getCheckboxItems() == null || this.checkboxModel.getCheckboxItems().size() == 0) {
            Iterator<TokenAuthorizationIssuanceCriterion> list = new ArrayList();
            for (String name : allNames) {
                CheckboxItem item = new CheckboxItem(name);
                item.setChecked(true);
                list.add((TokenAuthorizationIssuanceCriterion)item);
            }
            this.checkboxModel.setCheckboxItems((List<CheckboxItem>)((Object)list));
        }
        if (attrMap != null) {
            for (AttrMappingValue attrValue : attrMap.values()) {
                if (attrValue.getType() == SourceType.OTHER_DATA_STORE && (StringUtils.isEmpty((String)this.getAttributeSourceId()) || this.getAttributeSourceId().equals(attrValue.getAttributeSourceId()))) {
                    this.checkboxModel.setChecked(attrValue.getValue());
                    continue;
                }
                if (attrValue.getType() != SourceType.EXPRESSION) continue;
                this.addAttributesFromExpression(attrValue.getValue(), this.checkboxModel);
            }
            if (criteria != null) {
                for (TokenAuthorizationIssuanceCriterion criterion : criteria) {
                    if (criterion.getAttrSourceType() == SourceType.OTHER_DATA_STORE && (StringUtils.isEmpty((String)this.getAttributeSourceId()) || this.getAttributeSourceId().equals(criterion.getAttrSourceId()))) {
                        this.checkboxModel.setChecked(criterion.getAttrName());
                        continue;
                    }
                    if (criterion.getAttrSourceType() != SourceType.EXPRESSION) continue;
                    HashSet temp = new HashSet();
                    this.addAttributesFromExpression(criterion.getExpr(), this.checkboxModel);
                }
            }
        }
        if ((attributeSourceFilterReferences = this.getReferencesInAllAttributeSourceFiltersFromDisk()) != null) {
            for (String referenceId : attributeSourceFilterReferences) {
                if (!referenceId.startsWith(this.getPrefix())) continue;
                this.checkboxModel.setChecked(referenceId.substring(this.getPrefix().length()));
            }
        }
    }

    private void addAttributesFromExpression(String expression, CheckboxModel checkboxModel) {
        try {
            Object parsedExpression = Ognl.parseExpression((String)expression);
            OgnlHelper oh = new OgnlHelper(this.getPrefix());
            oh.searchForDataColumns(parsedExpression);
            HashSet temp = new HashSet();
            oh.addListToSet(temp);
            for (String attrToCheck : temp) {
                checkboxModel.setChecked(attrToCheck);
            }
        }
        catch (OgnlException e) {
            this.log.debug((Object)e);
        }
    }

    public CheckboxModel getCheckboxModel() {
        return this.checkboxModel;
    }

    public List<String> getAllFields() {
        return this.customSource.getDriver().getAvailableFields();
    }

    public List<String> getSelectedFields() {
        DataSourceManager dsMgr;
        SourceDescriptor descriptor;
        RetrieveAttributeSourceInstance parent = this.findParent(RetrieveAttributeSourceInstance.class);
        CustomDataSource selectedCustomDataSource = parent.getSelectedCustomDataSource();
        if (selectedCustomDataSource != null && (descriptor = (dsMgr = MgmtFactory.getDataSourceManager()).getSourceDescriptor(selectedCustomDataSource.getDriverClassName())) instanceof CustomDataSourceDriverDescriptor && !((CustomDataSourceDriverDescriptor)descriptor).isShowSelectCustomSourceFields()) {
            dsMgr.loadCustomDataSourceDriver(selectedCustomDataSource);
            return selectedCustomDataSource.getDriver().getAvailableFields();
        }
        return this.checkboxModel.getSelectedNames();
    }

    @Override
    public void onResumeDraft() {
        this.resumeDraft = true;
        this.onStateActivated();
        this.resumeDraft = false;
    }

    private Set<String> getReferencesInAllAttributeSourceFiltersFromDisk() {
        Set<String> references = null;
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            references = mappingTasklet.getReferencesInAllAttributeSourceFiltersFromDisk();
        }
        return references;
    }

    private String getPrefix() {
        Object prefix = "ds.";
        String attrSourceId = this.getAttributeSourceId();
        if (attrSourceId != null) {
            prefix = (String)prefix + attrSourceId + ".";
        }
        return prefix;
    }

    private String getAttributeSourceId() {
        String attributeSourceId = null;
        SpAttributeSourceTasklet spAttributeSourceTasklet = this.findParent(SpAttributeSourceTasklet.class);
        if (spAttributeSourceTasklet != null) {
            attributeSourceId = spAttributeSourceTasklet.getId();
        }
        return attributeSourceId;
    }
}

