/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAttributeSourceTasklet;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGeneratorMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractViewOnlyTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.AttributeSourceFactory;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SelectDataSourceState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String attrSourceDesc;
    private String attrSourceDescFromDisk;
    private String attrSourceId;
    protected String dataSourceDesc;
    private DataSource.DSType dataSourceType = DataSource.DSType.None;
    protected transient DataSource selectedDataSource;
    protected String selectedDataSourceId;
    private transient StringPairPropertySelectionModel activeDataSourceList;
    private AttributeMapping mapping;
    private final boolean requireSelection;

    public SelectDataSourceState(Tasklet value, String name) {
        this(value, name, true);
    }

    public SelectDataSourceState(Tasklet value, String name, boolean requireSelection) {
        super(value, name);
        this.setMenuName("Data Store");
        this.requireSelection = requireSelection;
        this.initDsDropDownList();
    }

    @Override
    public String getNoteKey() {
        if (this.getIsOidc() && this.getClass().equals(SelectDataSourceState.class)) {
            return super.getNoteKey() + "_Oidc";
        }
        return super.getNoteKey();
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    private void initDsDropDownList() {
        this.activeDataSourceList = new StringPairPropertySelectionModel(this.requireSelection);
        if (!this.requireSelection) {
            this.activeDataSourceList.add("No Data Store", null);
            this.activeDataSourceList.add("-----------------", null);
        }
    }

    @Override
    public void onStateActivated() {
        if (this.selectedDataSource == null || this.activeDataSourceList == null) {
            this.populate();
        }
        this.setReadOnlyIfNeeded();
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
        this.populate();
        if (this.selectedDataSourceId != null) {
            this.selectedDataSource = this.getDataSourceById(this.selectedDataSourceId);
        }
        this.setReadOnlyIfNeeded();
    }

    @Override
    public void prepareForTestDraft() {
        this.setTaskletToEditToNull();
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeSource attributeSource;
        this.mapping = (AttributeMapping)dataFromDisk;
        AttributeSource attributeSource2 = attributeSource = this.mapping != null ? this.mapping.getAttributeSource() : null;
        if (attributeSource != null) {
            this.attrSourceDesc = this.attrSourceDescFromDisk = attributeSource.getDescription();
            this.attrSourceId = attributeSource.getId();
            DataSource tempSource = attributeSource.getDataSource();
            if (this.selectedDataSource == null || !this.selectedDataSource.getId().equals(tempSource.getId())) {
                this.selectedDataSource = tempSource;
                if (tempSource != null) {
                    this.selectedDataSourceId = this.selectedDataSource.getId();
                    this.populate();
                }
                this.getParent().reconfigureTransitions(this);
            } else {
                this.populate();
            }
        } else {
            this.setSelectedDataSource(null);
            this.populate();
        }
    }

    protected void populate() {
        List<DataSource> dataSources = this.loadDataSources();
        dataSources.sort((a, b) -> a.getDescription().compareToIgnoreCase(b.getDescription()));
        this.createActiveDataSourceModel(dataSources);
        if (this.selectedDataSource != null) {
            for (DataSource ds : dataSources) {
                if (!ds.getId().equals(this.selectedDataSource.getId())) continue;
                this.selectedDataSourceId = this.selectedDataSource.getId();
                this.dataSourceDesc = ds.getDescription();
                this.determineType(ds);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping attributeMapping = (AttributeMapping)dataToDisk;
        if (this.selectedDataSource != null) {
            String type = this.selectedDataSource.getDataSourceType();
            String id = this.generateAttributeSourceId();
            AttributeSource attributeSource = AttributeSourceFactory.getAttributeSource((String)type, (String)this.attrSourceDesc, (String)this.selectedDataSource.getId(), (String)id);
            attributeMapping.addAttributeSource(attributeSource);
        }
        return true;
    }

    public String generateAttributeSourceId() {
        String id = this.isUseOtherValuesWithOneMapping() && !StringUtils.isEmpty((String)this.attrSourceId) ? this.attrSourceId : null;
        return id;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void reset() {
        this.dataSourceDesc = "";
        this.dataSourceType = DataSource.DSType.None;
        this.attrSourceDesc = "";
        this.attrSourceId = "";
        this.selectedDataSource = null;
        this.selectedDataSourceId = "";
        this.mapping = null;
        this.initDsDropDownList();
        this.getParent().reconfigureTransitions(this);
    }

    protected List<DataSource> loadDataSources() {
        DataSourceManager dataMgr = MgmtFactory.getDataSourceManager();
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        dataSources.addAll(dataMgr.getJdbcDataSources());
        dataSources.addAll(dataMgr.getLdapDataSources());
        dataSources.addAll(dataMgr.getCustomDataSources());
        return dataSources;
    }

    private DataSource getDataSourceById(String id) {
        for (DataSource datasource : this.loadDataSources()) {
            if (!datasource.getId().equals(id)) continue;
            return datasource;
        }
        return null;
    }

    protected void createActiveDataSourceModel(List<DataSource> dataSources) {
        this.initDsDropDownList();
        for (DataSource ds : dataSources) {
            this.activeDataSourceList.add(ds.getDescription(), ds);
        }
    }

    protected void determineType(DataSource ds) {
        this.dataSourceType = ds instanceof JdbcDataSource ? DataSource.DSType.JDBC : (ds instanceof LdapDataSource ? DataSource.DSType.LDAP : (ds instanceof CustomDataSource ? DataSource.DSType.Other : DataSource.DSType.None));
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.selectedDataSource != null) {
            this.dataSourceDesc = this.selectedDataSource.getDescription();
            this.selectedDataSourceId = this.selectedDataSource.getId();
            this.determineType(this.selectedDataSource);
        } else {
            this.dataSourceDesc = null;
            this.dataSourceType = DataSource.DSType.None;
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        MappingTasklet grandParent;
        SpAttributeSourceTasklet parent;
        AttributeSourceApi.ConnectionType connectionType = ((AttributeSourceApi)((Object)this.getWizard())).getConnectionType();
        delegate.setFormComponent(null);
        if (this.isUseOtherValuesWithOneMapping() && this.isAttributeSourceIdRequired() && StringUtils.isBlank((String)this.attrSourceId)) {
            delegate.record(this.getMessage("Attribute_source_id_required"), ValidationConstraint.REQUIRED);
        }
        if (this.isUseOtherValuesWithOneMapping() && this.isAttributeSourceIdRequired() && !StringUtils.isBlank((String)this.attrSourceId)) {
            if (!ValidationUtil.isAlphaNumeric((String)this.attrSourceId)) {
                delegate.record(this.getMessage("Attribute_source_id_must_be_alphanumeric"), ValidationConstraint.REQUIRED);
            } else {
                parent = this.getParent(SpAttributeSourceTasklet.class);
                grandParent = this.findParent(MappingTasklet.class);
                if (grandParent != null && grandParent.checkForDuplicateIds(this.attrSourceId.trim(), parent)) {
                    delegate.record(this.getMessage("Attribute_source_id_exists"), ValidationConstraint.REQUIRED);
                }
            }
        }
        if (connectionType == AttributeSourceApi.ConnectionType.SP) {
            if (StringUtils.isBlank((String)this.attrSourceDesc)) {
                delegate.record(this.getMessage("Attribute_source_description_required"), ValidationConstraint.REQUIRED);
            }
            parent = this.getParent(SpAttributeSourceTasklet.class);
            grandParent = this.findParent(MappingTasklet.class);
            if (grandParent != null && grandParent.checkForDuplicateDescriptions(this.attrSourceDesc.trim(), parent)) {
                delegate.record(this.getMessage("Attribute_source_description_exists"), ValidationConstraint.REQUIRED);
            }
        }
        if (this.selectedDataSource == null && this.requireSelection) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Data_store_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean onStateExit() {
        if (!this.handleOnStateExit(true)) {
            return false;
        }
        return super.onStateExit();
    }

    protected boolean handleOnStateExit(boolean shouldRecordErrorMsg) {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        if (!this.isViewOnly() && this.selectedDataSource != null && !dsMgr.test(this.selectedDataSource)) {
            if (this.delegate == null) {
                this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
            }
            if (shouldRecordErrorMsg) {
                this.recordErrorMsg(this.getMessage("Data_store_unavailable"));
            }
            return false;
        }
        return true;
    }

    @Override
    public void onResumeDraft() {
        if (this.selectedDataSource == null && this.selectedDataSourceId != null) {
            this.selectedDataSource = this.getDataSourceById(this.selectedDataSourceId);
        }
        this.createActiveDataSourceModel(this.loadDataSources());
    }

    public String getAttrSourceDesc() {
        return this.attrSourceDesc;
    }

    public void setAttrSourceDesc(String attrSourceDesc) {
        this.attrSourceDesc = attrSourceDesc;
    }

    public String getAttrSourceId() {
        return this.attrSourceId;
    }

    public void setAttrSourceId(String attrSourceId) {
        this.attrSourceId = attrSourceId;
    }

    public String getDataSourceDesc() {
        return this.dataSourceDesc;
    }

    public void setDataSourceDesc(String dataSourceDesc) {
        this.dataSourceDesc = dataSourceDesc;
    }

    public String getDataSourceTypeString() {
        return DataSource.getTypeDescription((DataSource.DSType)this.dataSourceType);
    }

    public DataSource.DSType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSource.DSType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public StringPairPropertySelectionModel getActiveDataSourceList() {
        return this.activeDataSourceList;
    }

    public void setActiveDataSourceList(StringPairPropertySelectionModel activeDataSourceList) {
        this.activeDataSourceList = activeDataSourceList;
    }

    public DataSource getSelectedDataSource() {
        return this.selectedDataSource;
    }

    public void setSelectedDataSource(DataSource selectedDataSource) {
        if (this.selectedDataSource == null || selectedDataSource == null || !this.selectedDataSourceId.equals(selectedDataSource.getId())) {
            this.selectedDataSource = selectedDataSource;
            if (selectedDataSource != null) {
                this.selectedDataSourceId = selectedDataSource.getId();
                this.dataSourceDesc = selectedDataSource.getDescription();
            }
            this.determineType(this.selectedDataSource);
            this.getParent().reconfigureTransitions(this);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String dataStore = this.getMessage("Data_store");
        if (this.selectedDataSource != null) {
            AttributeSourceApi.ConnectionType connectionType = ((AttributeSourceApi)((Object)this.getWizard())).getConnectionType();
            if (connectionType == AttributeSourceApi.ConnectionType.SP && !StringUtils.isBlank((String)this.attrSourceDesc)) {
                summaryList.add(new SummaryInfo(this.getMessage("Attribute_source"), this.attrSourceDesc, this));
            }
            if (!StringUtils.isBlank((String)this.attrSourceId)) {
                summaryList.add(new SummaryInfo(this.getMessage("Attribute_source_id"), this.attrSourceId, this));
            }
            summaryList.add(new SummaryInfo(this.getMessage("Type"), this.selectedDataSource.getDataSourceType(), this));
            summaryList.add(new SummaryInfo(dataStore, this.selectedDataSource.getDescription(), this));
        } else {
            summaryList.add(new SummaryInfo(dataStore, "No Data Store defined", this));
        }
    }

    public CustomDataSource getSelectedCustomAttributeSource() {
        return (CustomDataSource)this.selectedDataSource;
    }

    public boolean isUseOtherValuesWithOneMapping() {
        boolean useOtherValuesWithOneMapping = false;
        SpAttributeSourceTasklet spAttributeSourceTasklet = this.findParent(SpAttributeSourceTasklet.class);
        if (spAttributeSourceTasklet != null) {
            useOtherValuesWithOneMapping = spAttributeSourceTasklet.isUseOtherValuesWithOneMapping();
        }
        return useOtherValuesWithOneMapping;
    }

    public boolean isAttributeSourceIdRequired() {
        return this.isNewAttributeSource() || this.isMultiAttributeSourceMapping();
    }

    public boolean isMultiAttributeSourceMapping() {
        boolean multiAttributeSourceMapping = false;
        MappingTasklet parent = this.findParent(MappingTasklet.class);
        if (parent != null) {
            multiAttributeSourceMapping = parent.isMultiAttributeSourceMapping();
        }
        return multiAttributeSourceMapping;
    }

    private boolean isNewAttributeSource() {
        return this.attrSourceDescFromDisk == null;
    }

    private void setReadOnlyIfNeeded() {
        Tasklet tasklet = this.getParent();
        if (tasklet != null) {
            if (tasklet instanceof AbstractViewOnlyTasklet) {
                AbstractViewOnlyTasklet voTasklet = (AbstractViewOnlyTasklet)tasklet;
                if (voTasklet.showSaveAll()) {
                    voTasklet.setReadOnly();
                }
            } else if (tasklet instanceof WsTrustTokenGeneratorMappingTasklet) {
                WsTrustTokenGeneratorMappingTasklet wsTasklet = (WsTrustTokenGeneratorMappingTasklet)tasklet;
                if (this.getParent().showSaveAll()) {
                    wsTasklet.setReadOnly();
                }
            } else if (tasklet instanceof UserProvisioningTasklet) {
                UserProvisioningTasklet provTasklet = (UserProvisioningTasklet)tasklet;
                if (this.getParent().showSaveAll()) {
                    provTasklet.setReadOnly();
                }
            }
        }
    }
}

