/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.state.impl.ManageDataSourcesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SelectDataSourceTypeState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private DataSource selectedDataSource;
    private StringPairPropertySelectionModel dsList;
    private String sourceName;
    private boolean maskAttributeValues;

    public SelectDataSourceTypeState(Tasklet value) {
        super(value);
        this.setMenuName("Data Store Type");
        this.createDsListModel();
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof JdbcDataSource) {
            this.setSelectedDataSource((DataSource)((JdbcDataSource)dataFromDisk));
        } else if (dataFromDisk instanceof LdapDataSource) {
            this.setSelectedDataSource((DataSource)((LdapDataSource)dataFromDisk));
        } else {
            this.setSelectedDataSource((DataSource)((CustomDataSource)dataFromDisk));
        }
        this.getParent().reconfigureTransitions();
    }

    private void initDsTypeDropDownList() {
        this.dsList = new StringPairPropertySelectionModel(false);
        this.dsList.add("-----------------", null);
    }

    public DSType getSelectedDataSourceType() {
        if (this.selectedDataSource == null) {
            return DSType.Database;
        }
        switch (this.selectedDataSource.getDSType()) {
            case JDBC: {
                return DSType.Database;
            }
            case LDAP: {
                if (((LdapDataSource)this.selectedDataSource).isGatewayEnabled()) {
                    return DSType.LDAP_GATEWAY;
                }
                return DSType.LDAP;
            }
            case Other: {
                return DSType.Other;
            }
        }
        return DSType.Database;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly() && component != null) {
            DataSourceTasklet dataSourceTasklet;
            IFormComponent ic;
            if (this.selectedDataSource == null) {
                ic = (IFormComponent)component.getComponent("adapterList");
                delegate.setFormComponent(ic);
                delegate.record(this.getMessage("Type_required"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.sourceName)) {
                ic = (IFormComponent)component.getComponent("instanceName");
                delegate.setFormComponent(ic);
                delegate.record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            }
            if ((dataSourceTasklet = this.getParent(DataSourceTasklet.class)).isDuplicate(this.sourceName, this.findParentState(ManageDataSourcesState.class), false)) {
                IFormComponent ic2 = (IFormComponent)component.getComponent("instanceName");
                delegate.setFormComponent(ic2);
                delegate.record(this.getMessage("Instance_name_in_use"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String dsType = null;
        switch (this.selectedDataSource.getDSType()) {
            case Other: {
                dsType = this.getMessage("Other");
                break;
            }
            case JDBC: {
                dsType = this.getMessage("Database");
                break;
            }
            case LDAP: {
                dsType = this.getMessage("LDAP");
                break;
            }
            default: {
                dsType = this.getMessage("Database");
            }
        }
        summaryList.add(new SummaryInfo("Type of Data Store", dsType, this));
    }

    private void createDsListModel() {
        this.dsList = new StringPairPropertySelectionModel(true);
        this.dsList.add("Database (JDBC)", new JdbcDataSource());
        this.dsList.add("Directory (LDAP)", new LdapDataSource());
        this.dsList.add("PingOne LDAP Gateway", new LdapDataSource(true));
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        Collection customSourceDescriptors = dsMgr.discoverSourceDescriptors().stream().sorted(Comparator.comparing(n -> n.getType())).collect(Collectors.toCollection(LinkedList::new));
        for (SourceDescriptor descriptor : customSourceDescriptors) {
            CustomDataSource customDataSource = new CustomDataSource();
            customDataSource.setDescriptor((PluginDescriptor)descriptor);
            customDataSource.setDriverClassName(descriptor.getDriverClassName());
            this.dsList.add(descriptor.getType(), customDataSource);
        }
    }

    public StringPairPropertySelectionModel getDsList() {
        return this.dsList;
    }

    public void setDsList(StringPairPropertySelectionModel dsList) {
        this.dsList = dsList;
    }

    public DataSource getSelectedDataSource() {
        return this.selectedDataSource;
    }

    public void setSelectedDataSource(DataSource selectedDataSource) {
        this.selectedDataSource = selectedDataSource;
        this.getParent().reconfigureTransitions();
    }

    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName != null ? sourceName.trim() : null;
    }

    public boolean isShowFIPSStatus() {
        if (!PropertyInfo.isBCFIPSMode()) {
            return false;
        }
        return this.selectedDataSource != null && this.selectedDataSource instanceof CustomDataSource;
    }

    public String getFipsStatus() {
        if (this.selectedDataSource != null && this.selectedDataSource instanceof CustomDataSource) {
            CustomDataSource customDataSource = (CustomDataSource)this.selectedDataSource;
            if (customDataSource.getDriver() == null) {
                MgmtFactory.getDataSourceManager().loadCustomDataSourceDriver(customDataSource);
            }
            SourceDescriptor descriptor = customDataSource.getDriver().getSourceDescriptor();
            return AdapterUtils.getPluginFipsStatus((String)descriptor.getPluginClassName(), (Map)descriptor.getMetadata()).getDisplayName();
        }
        return "";
    }

    public boolean isGatewayEnabled() {
        if (this.selectedDataSource != null && this.selectedDataSource instanceof LdapDataSource) {
            return ((LdapDataSource)this.selectedDataSource).isGatewayEnabled();
        }
        return false;
    }

    public static enum DSType {
        Database("Database"),
        LDAP("LDAP"),
        LDAP_GATEWAY("LDAP Gateway"),
        Other("Other"),
        None("None");

        String displayName;

        private DSType(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

