/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.fsm.state.impl.SelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.StringPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.websso.profiles.sp.provisioning.ProvisioningProcessorManager;

public class SelectDatabaseSchemaAndStoredProcState
extends SelectDatabaseTableAndColumnsState {
    private static final long serialVersionUID = 20L;
    private String selectedInsertStoredProcedure;
    private String previouslySelectedInsertStoredProcedure;
    private List<String> insertStoredProcedures;
    private List<ResultInfo> allInsertStoredProcedureColumnsWithMetadata;
    private transient IPropertySelectionModel insertStoredProcedureList;
    private static final String NO_STORED_PROC_LIST = "<stored procedure list not available>";
    static final IPropertySelectionModel NO_INSERT_STORED_PROC_MODEL = new StringPropertySelectionModel(new String[]{"<stored procedure list not available>"});
    private boolean isPopulated = false;

    public SelectDatabaseSchemaAndStoredProcState(Tasklet value) {
        super(value);
    }

    public SelectDatabaseSchemaAndStoredProcState(Tasklet value, String cardName, String menuName) {
        super(value, cardName, menuName);
    }

    @Override
    public void onStateActivated() {
        if (!this.isViewOnly()) {
            JdbcDataSource tempDataSource = this.getSelectedDataSource();
            if (!this.isPopulated && this.mapping != null) {
                this.prepareCaches();
                this.resetAllValues();
                this.populateLists();
                this.populateSelectedValues();
                this.isPopulated = true;
            }
            if (this.dataSource == null || tempDataSource != null && !tempDataSource.equals((Object)this.dataSource)) {
                this.previouslySelectedInsertStoredProcedure = "";
                this.dataSource = tempDataSource;
                this.prepareCaches();
                this.resetAllValues();
                this.populateLists();
            }
            if (this.schemaList == null) {
                if (!this.schemas.isEmpty()) {
                    if (!this.schemas.contains(this.selectedSchema)) {
                        this.selectedSchema = (String)this.schemas.get(0);
                    }
                    this.schemaList = this.createPairModel(this.schemas);
                } else {
                    this.selectedSchema = "<schema list not available>";
                    this.previouslySelectedSchema = "<schema list not available>";
                    this.schemaList = NO_SCHEMA_MODEL;
                }
            }
            if (this.insertStoredProcedureList == null) {
                this.insertStoredProcedureList = this.createPairModel(this.insertStoredProcedures);
            }
        }
    }

    @Override
    protected void populateSelectedValues() {
        AttributeSource source = this.mapping.getAttributeSource();
        this.dataSource = (JdbcDataSource)source.getDataSource();
        this.previouslySelectedSchema = this.selectedSchema = source.getParameter("schema");
        this.selectedInsertStoredProcedure = source.getParameter("storedProcedure");
        HashSet<String> temp = new HashSet<String>();
        for (AttrMappingValue v : this.mapping.getAttributeMap().values()) {
            if (v.getType() == SourceType.JDBC_DATA_STORE) {
                temp.add(v.getValue());
                continue;
            }
            if (v.getType() == SourceType.TEXT) {
                Set keys = Substituter.parseReferences((String)v.getValue());
                for (String s : keys) {
                    if (!s.startsWith(this.getPrefix())) continue;
                    temp.add(s.substring(this.getPrefix().length()));
                }
                continue;
            }
            if (v.getType() != SourceType.EXPRESSION) continue;
            try {
                Object parsedExpression = Ognl.parseExpression((String)v.getValue());
                OgnlHelper oh = new OgnlHelper(this.getPrefix());
                oh.searchForDataColumns(parsedExpression);
                oh.addListToSet(temp);
            }
            catch (OgnlException e) {
                this.log.debug((Object)e);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeSource source = null;
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        if (t != null) {
            IdpConnection tempConnection = (IdpConnection)dataToDisk;
            UserProvisioning userProvisioning = tempConnection.getUserProvisioning();
            if (userProvisioning != null) {
                source = userProvisioning.getAttributeSource();
            }
        } else {
            AttributeMapping tempMapping = (AttributeMapping)dataToDisk;
            source = tempMapping.getAttributeSource();
        }
        if (source != null) {
            source.setParameter("storedProcedure", this.selectedInsertStoredProcedure);
            if ("<schema list not available>".equals(this.selectedSchema)) {
                source.removeParameter("schema");
            } else {
                source.setParameter("schema", this.selectedSchema);
            }
        }
        return true;
    }

    @Override
    protected void resetValues() {
        if (!this.isViewOnly()) {
            this.prepStoredProcedures(this.selectedSchema, this.selectedInsertStoredProcedure);
            this.previouslySelectedSchema = this.selectedSchema;
            this.previouslySelectedInsertStoredProcedure = this.selectedInsertStoredProcedure;
        }
    }

    @Override
    public void resetAllValues() {
        this.schemas = new ArrayList();
        if (!this.isViewOnly()) {
            this.selectedSchema = "";
        }
        this.schemaList = new StringPairPropertySelectionModel();
        this.insertStoredProcedures = new ArrayList<String>();
        this.insertStoredProcedureList = new StringPairPropertySelectionModel();
        this.allInsertStoredProcedureColumnsWithMetadata = new ArrayList<ResultInfo>();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (NO_STORED_PROC_LIST.equalsIgnoreCase(this.selectedInsertStoredProcedure)) {
            delegate.record(this.getMessage("Stored_procedure_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean onStateExit() {
        return true;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    protected void populateLists() {
        SelectDatabaseTableAndColumnsState.DatabaseCache cache = (SelectDatabaseTableAndColumnsState.DatabaseCache)this.globalCache.get(this.getDataSourceId());
        this.schemas = new ArrayList();
        if (!this.isViewOnly()) {
            this.schemas = cache.fetchSchemasFromCache();
            if (this.schemas.isEmpty()) {
                this.insertStoredProcedures = cache.fetchStoredProceduresForSchemaFromCache(null);
            } else {
                this.schemaList = this.createPairModel(this.schemas);
                if (StringUtils.isBlank((String)this.selectedSchema)) {
                    for (String schema : this.schemas) {
                        this.insertStoredProcedures = cache.fetchStoredProceduresForSchemaFromCache(schema);
                    }
                    this.previouslySelectedSchema = this.selectedSchema;
                } else {
                    this.insertStoredProcedures = cache.fetchStoredProceduresForSchemaFromCache(this.selectedSchema);
                }
            }
            if (this.schemas.isEmpty()) {
                this.selectedSchema = "<schema list not available>";
                this.previouslySelectedSchema = "<schema list not available>";
                this.schemaList = NO_SCHEMA_MODEL;
            }
            this.loadInsertStoredProcedureElements(cache);
        }
    }

    @Override
    public void refreshCache() {
        this.globalCache.remove(this.getDataSourceId());
        String oldSelectedSchema = this.selectedSchema;
        String oldSelectedInsertStoredProcedure = this.selectedInsertStoredProcedure;
        this.prepareCaches();
        this.resetAllValues();
        this.populateLists();
        this.previouslySelectedSchema = this.selectedSchema = oldSelectedSchema;
        this.previouslySelectedInsertStoredProcedure = this.selectedInsertStoredProcedure = oldSelectedInsertStoredProcedure;
        this.prepStoredProcedures(this.selectedSchema, this.selectedInsertStoredProcedure);
        ProvisioningProcessorManager mgr = ProvisioningProcessorManager.getInstance();
        mgr.refresh();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (!this.isViewOnly()) {
            boolean changed = false;
            if (!this.selectedSchema.equals(this.previouslySelectedSchema)) {
                changed = true;
                this.selectedInsertStoredProcedure = "";
            }
            if (StringUtils.isBlank((String)this.selectedInsertStoredProcedure)) {
                this.selectedInsertStoredProcedure = NO_STORED_PROC_LIST;
            }
            if (!this.selectedInsertStoredProcedure.equals(this.previouslySelectedInsertStoredProcedure)) {
                changed = true;
            }
            if (changed) {
                this.resetValues();
                this.populateLists();
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedSchema != null && !this.selectedSchema.equals("<schema list not available>")) {
            summaryList.add(new SummaryInfo("Schema", this.selectedSchema, this));
        }
        summaryList.add(new SummaryInfo("Stored Procedure", this.selectedInsertStoredProcedure, this));
        if (this.allInsertStoredProcedureColumnsWithMetadata != null && !this.allInsertStoredProcedureColumnsWithMetadata.isEmpty()) {
            for (ResultInfo r : this.allInsertStoredProcedureColumnsWithMetadata) {
                summaryList.add(new SummaryInfo("Parameter", r.getColumnName(), this));
            }
        }
    }

    private void loadInsertStoredProcedureElements(SelectDatabaseTableAndColumnsState.DatabaseCache cache) {
        this.insertStoredProcedureList = this.createPairModel(this.insertStoredProcedures);
        if (!this.insertStoredProcedures.contains(this.selectedInsertStoredProcedure) && !this.insertStoredProcedures.isEmpty()) {
            this.selectedInsertStoredProcedure = this.insertStoredProcedures.get(0);
        }
        if (this.insertStoredProcedures.isEmpty()) {
            this.selectedInsertStoredProcedure = NO_STORED_PROC_LIST;
            this.insertStoredProcedureList = NO_INSERT_STORED_PROC_MODEL;
        }
        if (!NO_STORED_PROC_LIST.equals(this.selectedInsertStoredProcedure) && !this.selectedInsertStoredProcedure.equals(this.previouslySelectedInsertStoredProcedure)) {
            if (this.isViewOnly()) {
                this.insertStoredProcedures = new ArrayList<String>();
                this.allInsertStoredProcedureColumnsWithMetadata = new ArrayList<ResultInfo>();
            } else {
                this.insertStoredProcedures = cache.fetchStoredProceduresForSchemaFromCache(this.selectedSchema);
                this.allInsertStoredProcedureColumnsWithMetadata = cache.fetchUnsortedStoredProcedureColumnsFromCache(this.selectedSchema, this.selectedInsertStoredProcedure);
            }
            this.previouslySelectedInsertStoredProcedure = this.selectedInsertStoredProcedure;
        }
    }

    private void prepStoredProcedures(String schema, String selectedInsertStoredProcedure) {
        SelectDatabaseTableAndColumnsState.DatabaseCache cache = (SelectDatabaseTableAndColumnsState.DatabaseCache)this.globalCache.get(this.getDataSourceId());
        this.insertStoredProcedures = cache.fetchStoredProceduresForSchemaFromCache(schema);
        List<String> storedProcs = cache.fetchStoredProceduresForSchemaFromCache(schema);
        this.insertStoredProcedureList = this.createPairModel(storedProcs);
        this.allInsertStoredProcedureColumnsWithMetadata = cache.fetchUnsortedStoredProcedureColumnsFromCache(schema, selectedInsertStoredProcedure);
    }

    @Override
    public List<String> getAllColumns() {
        ArrayList<String> storedProcedureVariables = new ArrayList<String>();
        if (this.allInsertStoredProcedureColumnsWithMetadata != null) {
            for (ResultInfo r : this.allInsertStoredProcedureColumnsWithMetadata) {
                storedProcedureVariables.add(r.getColumnName());
            }
        }
        return storedProcedureVariables;
    }

    public IPropertySelectionModel getInsertStoredProcedureList() {
        return this.insertStoredProcedureList;
    }

    public String getSelectedInsertStoredProcedure() {
        return this.selectedInsertStoredProcedure;
    }

    public void setSelectedInsertStoredProcedure(String selectedInsertStoredProcedure) {
        this.selectedInsertStoredProcedure = selectedInsertStoredProcedure;
    }

    public List<ResultInfo> getAllInsertStoredProcedureColumnsWithMetadata() {
        return this.allInsertStoredProcedureColumnsWithMetadata;
    }

    public void setAllInsertStoredProcedureColumnsWithMetadata(List<ResultInfo> allInsertStoredProcedureColumnsWithMetadata) {
        this.allInsertStoredProcedureColumnsWithMetadata = allInsertStoredProcedureColumnsWithMetadata;
    }
}

