/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ExportMetadataTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.MetaDataInfo;

public class SelectExportModeState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    public static final Integer CONNECTION_MODE = 0;
    public static final Integer MANUAL_MODE = 1;
    private Integer mode = CONNECTION_MODE;
    private boolean usesecondaryPortForSoapChannel = false;

    public SelectExportModeState(IWizard owner) {
        super(owner);
        this.setMenuName("Metadata Mode");
    }

    @Override
    public void reset() {
        this.mode = CONNECTION_MODE;
        this.usesecondaryPortForSoapChannel = false;
    }

    @Override
    public void onStateActivated() {
        if (!this.getHasConnections()) {
            this.mode = MANUAL_MODE;
        }
    }

    public Integer getMode() {
        return this.mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public boolean isUsesecondaryPortForSoapChannel() {
        return this.usesecondaryPortForSoapChannel;
    }

    public void setUsesecondaryPortForSoapChannel(boolean usesecondaryPortForSoapChannel) {
        this.usesecondaryPortForSoapChannel = usesecondaryPortForSoapChannel;
    }

    @Override
    public boolean save(Object dataToDisk) {
        MetaDataInfo metadataInfo = (MetaDataInfo)dataToDisk;
        metadataInfo.setUseSecondaryPortForSoapChannel(this.usesecondaryPortForSoapChannel);
        return true;
    }

    public boolean getHasConnections() {
        ConnectionManager connManager = MgmtFactory.getConnectionManager();
        ExportMetadataTasklet tasklet = this.findParent(ExportMetadataTasklet.class);
        if (tasklet.exportIDP()) {
            return !connManager.getFilteredSamlSpConnections().isEmpty();
        }
        return !connManager.getFilteredSamlIdpConnections().isEmpty();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Metadata mode", this.mode.equals(MANUAL_MODE) ? "Select information manually" : "Use connection", this));
        summaryList.add(new SummaryInfo("Use the secondary port for SOAP channel", this.usesecondaryPortForSoapChannel ? "true" : "false", this));
    }
}

