/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.IdpConnection;

public class SelectIdpAccountLinkingState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private MappingType mappingType = MappingType.MAPPING;
    private boolean addlAttrs;
    private boolean disableCheckbox = true;
    private IdpConnection idpConnection;

    public SelectIdpAccountLinkingState(Tasklet value) {
        super(value);
        this.setMenuName("Identity Mapping");
    }

    @Override
    public void populate(Object dataFromDisk) {
        boolean isNewConnection;
        this.idpConnection = (IdpConnection)dataFromDisk;
        boolean bl = isNewConnection = this.idpConnection.getId() == null;
        if (!isNewConnection) {
            if (this.idpConnection.isLinking()) {
                this.mappingType = MappingType.LINKING;
                this.disableCheckbox = false;
                this.addlAttrs = this.idpConnection.isIncludeAdditionalAttributes();
            } else {
                this.mappingType = !this.idpConnection.getTargetAttributeMappings().isEmpty() || !this.idpConnection.getC2cContractMappings().isEmpty() ? MappingType.MAPPING : MappingType.NONE;
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection tempConnection = (IdpConnection)dataToDisk;
        if (this.isLinking()) {
            tempConnection.setLinking(true);
        }
        tempConnection.setIncludeAdditionalAttributes(this.addlAttrs);
        return true;
    }

    @Override
    public void reset() {
        this.mappingType = MappingType.MAPPING;
        this.addlAttrs = false;
        this.disableCheckbox = true;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.isLinking()) {
            this.disableCheckbox = false;
        } else {
            this.disableCheckbox = true;
            this.addlAttrs = false;
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.isLinking()) {
            summaryList.add(new SummaryInfo("Enable Account Linking", Boolean.toString(true), this));
            summaryList.add(new SummaryInfo("Expecting a set of additional attributes", Boolean.toString(this.addlAttrs), this));
        } else if (this.isNone()) {
            summaryList.add(new SummaryInfo("Enable No Account Mapping", Boolean.toString(true), this));
        } else {
            summaryList.add(new SummaryInfo("Enable Account Mapping", Boolean.toString(true), this));
        }
    }

    public boolean getAddlAttrs() {
        return this.addlAttrs;
    }

    public void setAddlAttrs(boolean noAddlAttrs) {
        this.addlAttrs = noAddlAttrs;
    }

    public boolean getDisableCheckbox() {
        return this.disableCheckbox;
    }

    public void setDisableCheckbox(boolean disableCheckbox) {
        this.disableCheckbox = disableCheckbox;
    }

    public boolean isLinking() {
        return MappingType.LINKING == this.mappingType;
    }

    public boolean isNone() {
        return MappingType.NONE == this.mappingType;
    }

    public String getMappingType() {
        return this.mappingType.name();
    }

    public void setMappingType(String mappingType) {
        this.mappingType = MappingType.valueOf(mappingType);
    }

    public static String getLinkingName() {
        return MappingType.LINKING.name();
    }

    public static String getMappingName() {
        return MappingType.MAPPING.name();
    }

    public static String getNoneName() {
        return MappingType.NONE.name();
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    public static enum MappingType {
        MAPPING,
        LINKING,
        NONE;

    }
}

