/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SPNameIdentifierMappingType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AssertionCreationTasklet;
import java.util.ArrayList;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.SpConnection;

public class SelectSpAccountLinkingState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    public static SPNameIdentifierMappingType pseudonymType = SPNameIdentifierMappingType.PSEUDONYM;
    public static SPNameIdentifierMappingType standardType = SPNameIdentifierMappingType.STANDARD;
    public static SPNameIdentifierMappingType transientType = SPNameIdentifierMappingType.TRANSIENT;
    private boolean noAddlPseudonymAttrs;
    private boolean noAddlTransientAttrs;
    private boolean disablePseudonymCheckbox = true;
    private boolean disableTransientCheckbox = true;
    private SpConnection spConnection;
    private SPNameIdentifierMappingType nameIdentifierMappingType = SPNameIdentifierMappingType.STANDARD;

    public SelectSpAccountLinkingState(Tasklet value) {
        super(value);
        this.setMenuName("Identity Mapping");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.spConnection = (SpConnection)dataFromDisk;
        this.nameIdentifierMappingType = SPNameIdentifierMappingType.fromFormatUri(this.spConnection.getNameIdFormat());
        switch (this.nameIdentifierMappingType) {
            case PSEUDONYM: {
                this.nameIdentifierMappingType = SPNameIdentifierMappingType.PSEUDONYM;
                this.disablePseudonymCheckbox = false;
                this.disableTransientCheckbox = true;
                this.noAddlTransientAttrs = this.spConnection.isIncludeAdditionalTransientAttributes();
                this.noAddlPseudonymAttrs = this.spConnection.isIncludeAdditionalAttributes();
                break;
            }
            case TRANSIENT: {
                this.nameIdentifierMappingType = SPNameIdentifierMappingType.TRANSIENT;
                this.disablePseudonymCheckbox = true;
                this.disableTransientCheckbox = false;
                this.noAddlTransientAttrs = this.spConnection.isIncludeAdditionalTransientAttributes();
                this.noAddlPseudonymAttrs = this.spConnection.isIncludeAdditionalAttributes();
                break;
            }
            case STANDARD: {
                this.nameIdentifierMappingType = SPNameIdentifierMappingType.STANDARD;
                this.disableTransientCheckbox = true;
                this.disablePseudonymCheckbox = true;
                this.noAddlTransientAttrs = this.spConnection.isIncludeAdditionalTransientAttributes();
                this.noAddlPseudonymAttrs = this.spConnection.isIncludeAdditionalAttributes();
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        SpConnection tempConnection = (SpConnection)dataToDisk;
        SPNameIdentifierMappingType nameIdentifierMappingType = this.getNameIdentifierMappingType();
        String nameIdFormat = nameIdentifierMappingType.getNameIdFormatUri();
        tempConnection.setNameIdFormat(nameIdFormat);
        tempConnection.setIncludeAdditionalAttributes(this.noAddlPseudonymAttrs);
        tempConnection.setIncludeAdditionalTransientAttributes(this.noAddlTransientAttrs);
        return true;
    }

    @Override
    public void reset() {
        this.nameIdentifierMappingType = SPNameIdentifierMappingType.STANDARD;
        this.noAddlPseudonymAttrs = false;
        this.noAddlTransientAttrs = false;
        this.disablePseudonymCheckbox = true;
        this.disableTransientCheckbox = true;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        switch (this.nameIdentifierMappingType) {
            case PSEUDONYM: {
                this.disablePseudonymCheckbox = false;
                this.disableTransientCheckbox = true;
                this.noAddlTransientAttrs = false;
                break;
            }
            case TRANSIENT: {
                this.disablePseudonymCheckbox = true;
                this.disableTransientCheckbox = false;
                this.noAddlPseudonymAttrs = false;
                break;
            }
            case STANDARD: {
                this.disablePseudonymCheckbox = true;
                this.disableTransientCheckbox = true;
                this.noAddlPseudonymAttrs = false;
                this.noAddlTransientAttrs = false;
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        switch (this.nameIdentifierMappingType) {
            case PSEUDONYM: {
                summaryList.add(new SummaryInfo(this.getMessage("Pseudonym"), new Boolean(true).toString(), this));
                summaryList.add(new SummaryInfo(this.getMessage("Pseudonym_addl_attrs"), new Boolean(this.noAddlPseudonymAttrs).toString(), this));
                break;
            }
            case TRANSIENT: {
                summaryList.add(new SummaryInfo(this.getMessage("Transient"), new Boolean(true).toString(), this));
                summaryList.add(new SummaryInfo(this.getMessage("Transient_addl_attrs"), new Boolean(this.noAddlTransientAttrs).toString(), this));
                break;
            }
            case STANDARD: {
                summaryList.add(new SummaryInfo(this.getMessage("Standard"), new Boolean(true).toString(), this));
            }
        }
    }

    public boolean getDisablePseudonymCheckbox() {
        return this.disablePseudonymCheckbox;
    }

    public boolean getDisableTransientCheckbox() {
        return this.disableTransientCheckbox;
    }

    public boolean getNoAddlPseudonymAttrs() {
        return this.noAddlPseudonymAttrs;
    }

    public void setNoAddlPseudonymAttrs(boolean noAddlPseudonymAttrs) {
        this.noAddlPseudonymAttrs = noAddlPseudonymAttrs;
    }

    public boolean getNoAddlTransientAttrs() {
        return this.noAddlTransientAttrs;
    }

    public void setNoAddlTransientAttrs(boolean noAddlTransientAttrs) {
        this.noAddlTransientAttrs = noAddlTransientAttrs;
    }

    public SPNameIdentifierMappingType getNameIdentifierMappingType() {
        return this.nameIdentifierMappingType;
    }

    public void setNameIdentifierMappingType(SPNameIdentifierMappingType nameIdentifierMappingType) {
        this.nameIdentifierMappingType = nameIdentifierMappingType;
    }

    public static SPNameIdentifierMappingType getPseudonymType() {
        return pseudonymType;
    }

    public static void setPseudonymType(SPNameIdentifierMappingType pseudonymType) {
        SelectSpAccountLinkingState.pseudonymType = pseudonymType;
    }

    public static SPNameIdentifierMappingType getStandardType() {
        return standardType;
    }

    public static void setStandardType(SPNameIdentifierMappingType standardType) {
        SelectSpAccountLinkingState.standardType = standardType;
    }

    public static SPNameIdentifierMappingType getTransientType() {
        return transientType;
    }

    public static void setTransientType(SPNameIdentifierMappingType transientType) {
        SelectSpAccountLinkingState.transientType = transientType;
    }

    @Override
    public boolean onStateExit() {
        AssertionCreationTasklet act = this.findParent(AssertionCreationTasklet.class);
        act.refreshStatesAfterMappingChange();
        return true;
    }
}

