/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PartnerUrlValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.MessageCustomizationCard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ServiceEndpointItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.domain.trans.DomainTranslator;

public abstract class ServiceEndpointState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    public static final String POST = "POST";
    public static final String ARTIFACT = "Artifact";
    public static final String REDIRECT = "Redirect";
    public static final String SOAP = "SOAP";
    private DomainTranslator domainTranslator;
    private Protocol protocol;
    private ArrayList<ServiceEndpointItem> endpoints = new ArrayList();
    private int lastIndex = -1;
    private boolean defaultServiceToAdd;
    private boolean defaultServiceToEdit;
    private String indexToAdd;
    private String indexToEdit;
    private String endpointUrlToAdd;
    private String endpointUrlToEdit;
    private String responseUrlToAdd;
    private String responseUrlToEdit;
    private String bindingToAdd;
    private String bindingToEdit;
    private boolean showEndpointUrlField;
    private boolean showResponseUrlField;
    private boolean showDefaultField;
    private boolean showIndexField;
    private boolean showBindingField;
    private boolean showAdvanced;
    private String[] baseBindings;

    public abstract LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> getMessageHooks();

    public abstract boolean getIsIdpConn();

    public abstract boolean getIsWsFed();

    public abstract boolean getIsEditingHook();

    public abstract void setIsEditingHook(boolean var1);

    public abstract Map<String, String> getName2ContextMap();

    public abstract StringPairPropertySelectionModel getHookTypes();

    public abstract String getSelectedHookType();

    public abstract void setSelectedHookType(String var1);

    public abstract String getSelectedHookExpression();

    public abstract void setSelectedHookExpression(String var1);

    public abstract String getLinkContextName();

    public abstract void setLinkContextName(String var1);

    public ServiceEndpointState(Tasklet value) {
        super(value);
    }

    private StringPairPropertySelectionModel createBindingStringPairModel() {
        StringPairPropertySelectionModel bindingList = new StringPairPropertySelectionModel(true);
        for (int i = 0; i < Array.getLength(this.baseBindings); ++i) {
            bindingList.add(this.baseBindings[i], this.baseBindings[i]);
        }
        bindingList.sort();
        return bindingList;
    }

    public void add() {
        if (this.noUrlErrorsAndReq(this.endpointUrlToAdd)) {
            ServiceEndpointItem newItem = new ServiceEndpointItem(this.endpointUrlToAdd, this.bindingToAdd);
            if (this.showDefaultField) {
                if (this.defaultServiceToAdd) {
                    this.resetEndpointDefaultServices();
                    newItem.setDefaultService(true);
                } else if (!this.isDefaultEndpointSet()) {
                    newItem.setDefaultService(true);
                }
            }
            if (this.validate(newItem, this.indexToAdd == null ? "-1" : this.indexToAdd, this.responseUrlToAdd, this.endpointUrlToAdd, this.bindingToAdd)) {
                this.add(newItem);
                this.defaultServiceToAdd = false;
            }
        }
    }

    public void edit(int index) {
        this.lastIndex = index;
        ServiceEndpointItem item = this.endpoints.get(index);
        this.defaultServiceToEdit = item.getDefaultService();
        this.indexToEdit = item.getIndex();
        this.endpointUrlToEdit = item.getEndpointUrl();
        this.responseUrlToEdit = item.getResponseUrl();
        this.bindingToEdit = item.getBinding();
        item.setInEditMode(true);
    }

    public void update() {
        if (this.noUrlErrorsAndReq(this.endpointUrlToEdit)) {
            ServiceEndpointItem item = this.endpoints.get(this.lastIndex);
            if (this.showDefaultField) {
                if (item.getDefaultService()) {
                    this.resetEndpointDefaultServices();
                    item.setDefaultService(true);
                } else if (this.endpoints.size() == 2) {
                    ServiceEndpointItem other = this.endpoints.get(this.lastIndex == 1 ? 0 : 1);
                    other.setDefaultService(true);
                }
            }
            if (this.validate(item, this.indexToEdit == null ? Integer.toString(this.lastIndex) : this.indexToEdit, this.responseUrlToEdit, this.endpointUrlToEdit, this.bindingToEdit)) {
                item.setInEditMode(false);
            }
        }
    }

    protected boolean validate(ServiceEndpointItem item, String index, String responseUrl, String endpointUrl, String binding) {
        PartnerUrlValidator urlValidator;
        boolean errors = false;
        if (this.showIndexField) {
            if (StringUtils.isBlank((String)index)) {
                index = this.incrementIndex();
            }
            if (!ValidationUtil.isValidPort((String)index)) {
                this.delegate.record(this.getMessage("Invalid_index"), ValidationConstraint.NUMBER_FORMAT);
                errors = true;
            } else if (this.isDuplicateIndex(index)) {
                this.delegate.record(this.getMessage("Duplicate_index"), ValidationConstraint.NUMBER_FORMAT);
                errors = true;
            } else {
                item.setIndex(index);
            }
        }
        if (this.showResponseUrlField && !StringUtils.isBlank((String)responseUrl) && !ValidationUtil.isValidHttpOrHttpsUrl((String)responseUrl)) {
            if (this.isBaseUrlConfigured()) {
                if (!ValidationUtil.startsWithForwardSlash((String)responseUrl)) {
                    this.delegate.record(this.getMessage("Response_base_url_malformed"), ValidationConstraint.URL_FORMAT);
                    errors = true;
                }
            } else {
                this.delegate.record(this.getMessage("Malformed_response_url"), ValidationConstraint.URL_FORMAT);
                errors = true;
            }
        }
        if (this.showEndpointUrlField && !(urlValidator = PartnerUrlValidatorFactory.getBrowserSsoEndpointUrlValidator((String)endpointUrl, (boolean)this.isBaseUrlConfigured(), null)).validate()) {
            this.recordErrors(urlValidator.getErrors(), (IValidationDelegate)this.delegate);
            errors = true;
        }
        if (this.showBindingField && !this.isValidBinding(binding)) {
            this.delegate.record(this.getMessage("Invalid_binding"), ValidationConstraint.REQUIRED);
            errors = true;
        }
        if (!errors) {
            item.setEndpointUrl(endpointUrl);
            item.setBinding(binding);
            this.lastIndex = -1;
            if (this.showResponseUrlField) {
                item.setResponseUrl(responseUrl);
            }
        }
        return !errors;
    }

    public void cancelEdit() {
        if (this.lastIndex > -1) {
            ServiceEndpointItem item = this.endpoints.get(this.lastIndex);
            item.setInEditMode(false);
            this.lastIndex = -1;
        }
        if (this.getAllowAdvanced()) {
            this.showAdvanced = false;
            this.setIsEditingHook(false);
        }
    }

    public void delete(int index) {
        this.endpoints.remove(index);
        if (this.showDefaultField && !this.isDefaultEndpointSet() && this.endpoints.size() == 1) {
            ServiceEndpointItem item = this.endpoints.get(0);
            item.setDefaultService(true);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.endpoints.isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Endpoint_required"), ValidationConstraint.REQUIRED);
        }
        if (!this.isValidBindings()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Unrecognized_binding_exists"), ValidationConstraint.CONSISTENCY);
        }
        if (this.lastIndex != -1) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Finish_editing"), ValidationConstraint.REQUIRED);
        }
        if (this.showDefaultField) {
            boolean defaultSet = false;
            for (ServiceEndpointItem item : this.getEndpoints()) {
                if (!item.getDefaultService()) continue;
                defaultSet = true;
            }
            if (!defaultSet) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Default_endpoint_required"), ValidationConstraint.REQUIRED);
            }
        }
        if (this.anyRelativeUrls() && !this.isBaseUrlConfigured()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Relative_urls_but_no_base"), ValidationConstraint.REQUIRED);
        }
    }

    private boolean isDuplicateIndex(String index) {
        ArrayList<ServiceEndpointItem> list = this.endpoints;
        for (int i = 0; i < list.size(); ++i) {
            ServiceEndpointItem temp = list.get(i);
            if (!temp.getIndex().equals(index) || i == this.lastIndex) continue;
            return true;
        }
        return false;
    }

    private void resetEndpointDefaultServices() {
        for (ServiceEndpointItem item : this.endpoints) {
            item.setDefaultService(false);
        }
    }

    private boolean isDefaultEndpointSet() {
        for (ServiceEndpointItem item : this.endpoints) {
            if (!item.getDefaultService()) continue;
            return true;
        }
        return false;
    }

    private boolean noUrlErrorsAndReq(String url) {
        if (StringUtils.isBlank((String)url)) {
            this.delegate.record(this.getMessage("Endpoint_url_required"), ValidationConstraint.REQUIRED);
            return false;
        }
        return true;
    }

    private String incrementIndex() {
        Integer largestInt = 0;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            Integer temp = Integer.valueOf(this.endpoints.get(i).getIndex());
            if (temp <= largestInt || i == this.lastIndex) continue;
            largestInt = temp;
        }
        if (this.endpoints.size() > 0) {
            Integer n = largestInt;
            Integer n2 = largestInt = Integer.valueOf(largestInt + 1);
        }
        if (largestInt > 65535) {
            return "";
        }
        return largestInt.toString();
    }

    private void add(ServiceEndpointItem newItem) {
        this.endpoints.add(newItem);
        this.setEndpointUrlToAdd(null);
        this.setResponseUrlToAdd(null);
        this.setBindingToAdd(null);
        this.setIndexToAdd(null);
    }

    protected void resetAll() {
        this.defaultServiceToAdd = false;
        this.defaultServiceToEdit = false;
        this.indexToAdd = "";
        this.indexToEdit = "";
        this.endpointUrlToAdd = "";
        this.endpointUrlToEdit = "";
        this.responseUrlToAdd = "";
        this.responseUrlToEdit = "";
        this.bindingToAdd = "";
        this.bindingToEdit = "";
        this.endpoints.clear();
    }

    protected void putFirstSelectedBindingOnTop(String selectedBinding) {
        ArrayList<ServiceEndpointItem> list = this.getEndpoints();
        for (int i = 0; i < list.size(); ++i) {
            ServiceEndpointItem item = list.get(i);
            if (!selectedBinding.equals(item.getBinding())) continue;
            list.remove(i);
            list.add(0, item);
            break;
        }
        this.setEndpoints(list);
    }

    public String[] getRadioButtonBindingList() {
        String[] bindings = new String[this.getEndpoints().size()];
        for (int i = 0; i < this.getEndpoints().size(); ++i) {
            bindings[i] = this.getEndpoints().get(i).getBinding();
        }
        return bindings;
    }

    private boolean isValidBinding(String bindingToCheck) {
        return bindingToCheck != null;
    }

    protected String dropdownToBindingURI(String binding) {
        return this.domainTranslator.toBindingUri(binding);
    }

    protected String bindingURIToDropdown(String binding) {
        return this.domainTranslator.toBindingGuiName(binding);
    }

    public String getClassType() {
        if (this.lastIndex == -1) {
            return "plain";
        }
        return "disabled";
    }

    public ArrayList<ServiceEndpointItem> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(ArrayList<ServiceEndpointItem> endpoints) {
        this.endpoints = endpoints;
    }

    public String getBindingToAdd() {
        return this.bindingToAdd;
    }

    public void setBindingToAdd(String bindingToAdd) {
        this.bindingToAdd = bindingToAdd;
    }

    public String getBindingToEdit() {
        return this.bindingToEdit;
    }

    public void setBindingToEdit(String bindingToEdit) {
        this.bindingToEdit = bindingToEdit;
    }

    public String getEndpointUrlToAdd() {
        return this.endpointUrlToAdd;
    }

    public void setEndpointUrlToAdd(String endpointUrlToAdd) {
        this.endpointUrlToAdd = StringUtils.stripToEmpty((String)endpointUrlToAdd);
    }

    public String getEndpointUrlToEdit() {
        return this.endpointUrlToEdit;
    }

    public void setEndpointUrlToEdit(String endpointUrlToEdit) {
        this.endpointUrlToEdit = StringUtils.stripToEmpty((String)endpointUrlToEdit);
    }

    public String getResponseUrlToAdd() {
        return this.responseUrlToAdd;
    }

    public void setResponseUrlToAdd(String responseUrlToAdd) {
        this.responseUrlToAdd = StringUtils.stripToEmpty((String)responseUrlToAdd);
    }

    public String getResponseUrlToEdit() {
        return this.responseUrlToEdit;
    }

    public void setResponseUrlToEdit(String responseUrlToEdit) {
        this.responseUrlToEdit = StringUtils.stripToEmpty((String)responseUrlToEdit);
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(int lastIndex) {
        this.lastIndex = lastIndex;
    }

    public StringPairPropertySelectionModel getBindingList() {
        return this.createBindingStringPairModel();
    }

    public boolean getShowEndpointUrlField() {
        return this.showEndpointUrlField;
    }

    public void setShowEndpointUrlField(boolean showEndpointUrlField) {
        this.showEndpointUrlField = showEndpointUrlField;
    }

    public boolean getShowResponseUrlField() {
        return this.showResponseUrlField;
    }

    public void setShowResponseUrlField(boolean showResponseUrlField) {
        this.showResponseUrlField = showResponseUrlField;
    }

    public boolean getShowBindingField() {
        return this.showBindingField;
    }

    public void setShowBindingField(boolean showBindingField) {
        this.showBindingField = showBindingField;
    }

    public boolean getShowDefaultField() {
        return this.showDefaultField;
    }

    public void setShowDefaultField(boolean showDefaultField) {
        this.showDefaultField = showDefaultField;
    }

    public boolean getShowIndexField() {
        return this.showIndexField;
    }

    public void setShowIndexField(boolean showIndexField) {
        this.showIndexField = showIndexField;
    }

    public String getIndexToAdd() {
        return this.indexToAdd;
    }

    public void setIndexToAdd(String indexToAdd) {
        this.indexToAdd = indexToAdd;
    }

    public String getIndexToEdit() {
        return this.indexToEdit;
    }

    public void setIndexToEdit(String indexToEdit) {
        this.indexToEdit = indexToEdit;
    }

    public boolean getDefaultServiceToAdd() {
        return this.defaultServiceToAdd;
    }

    public void setDefaultServiceToAdd(boolean defaultServiceToAdd) {
        this.defaultServiceToAdd = defaultServiceToAdd;
    }

    public boolean getDefaultServiceToEdit() {
        return this.defaultServiceToEdit;
    }

    public void setDefaultServiceToEdit(boolean defaultServiceToEdit) {
        this.defaultServiceToEdit = defaultServiceToEdit;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (ServiceEndpointItem serviceEndpointItem : this.getEndpoints()) {
            StringBuilder sb = new StringBuilder();
            sb.append("URL: ").append(serviceEndpointItem.getEndpointUrl());
            sb.append(" (").append(serviceEndpointItem.getBinding()).append(")");
            if (serviceEndpointItem.getResponseUrl() != null) {
                sb.append(" Response URL: ").append(serviceEndpointItem.getResponseUrl());
            }
            summaryList.add(new SummaryInfo(this.getMessage("Endpoint"), sb.toString(), this));
        }
        if (this.getAllowAdvanced()) {
            for (MessageCustomizationCard.MessageHookEntry msgHookEntry : this.getMessageHooks().values()) {
                if (msgHookEntry.isDeleted()) continue;
                String msg = "Expression for variable '" + msgHookEntry.getName() + "'";
                summaryList.add(new SummaryInfo(this.getMessage("message_customization"), msg, this));
            }
        }
    }

    public String getFirstEndpointBinding() {
        return this.getEndpoints() != null && this.getEndpoints().size() > 0 ? this.getEndpoints().get(0).getBinding() : null;
    }

    public void setBaseBindings(String[] bindings) {
        this.baseBindings = bindings;
    }

    public String[] getBaseBindings() {
        return this.baseBindings;
    }

    @Override
    public String getMessageSimpleName() {
        return "ServiceEndpointState";
    }

    public boolean isArtifactBindingUsed() {
        for (ServiceEndpointItem item : this.endpoints) {
            if (!ARTIFACT.equals(item.getBinding())) continue;
            return true;
        }
        return false;
    }

    public boolean isPostOrRedirectBindingUsed() {
        return this.isPostBindingUsed() || this.isRedirectBindingUsed();
    }

    public boolean isPostBindingUsed() {
        for (ServiceEndpointItem i : this.endpoints) {
            if (!POST.equalsIgnoreCase(i.getBinding())) continue;
            return true;
        }
        return false;
    }

    public boolean isRedirectBindingUsed() {
        for (ServiceEndpointItem i : this.endpoints) {
            if (!REDIRECT.equalsIgnoreCase(i.getBinding())) continue;
            return true;
        }
        return false;
    }

    public boolean isSoapBindingUsed() {
        for (ServiceEndpointItem item : this.endpoints) {
            if (!SOAP.equals(item.getBinding())) continue;
            return true;
        }
        return false;
    }

    public boolean isOnlyArtifactBindingUsed() {
        return this.isArtifactBindingUsed() && !this.isPostOrRedirectBindingUsed() && !this.isSoapBindingUsed();
    }

    public boolean isOnlySoapBindingUsed() {
        return this.isSoapBindingUsed() && !this.isPostOrRedirectBindingUsed() && !this.isArtifactBindingUsed();
    }

    public boolean isAnyBindingUsed() {
        return !this.endpoints.isEmpty();
    }

    public boolean isAnySoapNotUsingHttps() {
        return this.isAnySoapNotUsingHttps(false);
    }

    public boolean isAnySoapNotUsingHttps(boolean checkBaseUrl) {
        boolean anyEndpointNotUsingHttps = false;
        for (ServiceEndpointItem item : this.endpoints) {
            String itemURL;
            if (!SOAP.equals(item.getBinding()) || (itemURL = item.getEndpointUrl().toLowerCase()).startsWith("https")) continue;
            if (itemURL.startsWith("http")) {
                anyEndpointNotUsingHttps = true;
                break;
            }
            if (checkBaseUrl && this.isBaseUrlConfigured()) {
                if (this.getBaseUrlString().toLowerCase().startsWith("https")) continue;
                anyEndpointNotUsingHttps = true;
                continue;
            }
            anyEndpointNotUsingHttps = true;
            break;
        }
        return anyEndpointNotUsingHttps;
    }

    public boolean isAnyArtifactNotUsingHttps() {
        for (ServiceEndpointItem item : this.endpoints) {
            if (!ARTIFACT.equals(item.getBinding()) || item.getEndpointUrl().toLowerCase().startsWith("https")) continue;
            return true;
        }
        return false;
    }

    public DomainTranslator getDomainTranslator() {
        return this.domainTranslator;
    }

    public void setDomainTranslator(Protocol protocol) {
        this.protocol = protocol;
        this.domainTranslator = DomainTranslator.getTranslator((Protocol)protocol);
    }

    private boolean isBaseUrlConfigured() {
        ConnectionTasklet c = this.getConnectionTasklet();
        return c != null ? c.isBaseUrlConfigured() : false;
    }

    private String getBaseUrlString() {
        ConnectionTasklet c = this.getConnectionTasklet();
        return c != null ? c.getBaseUrlString() : new String();
    }

    private ConnectionTasklet getConnectionTasklet() {
        Tasklet t = this.findParent(ConnectionTasklet.class);
        return t != null && t instanceof ConnectionTasklet ? (ConnectionTasklet)t : null;
    }

    private List<URL> serviceEndpointItemToUrlList(List<ServiceEndpointItem> endpoints) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ServiceEndpointItem item : endpoints) {
            Object temp = null;
            temp = ValidationUtil.startsWithForwardSlash((String)item.getEndpointUrl()) && this.isBaseUrlConfigured() ? this.getBaseUrlString() + item.getEndpointUrl() : item.getEndpointUrl();
            urls.add(this.stringToUrl((String)temp));
            if (!this.showResponseUrlField || StringUtils.isBlank((String)item.getResponseUrl())) continue;
            temp = ValidationUtil.startsWithForwardSlash((String)item.getResponseUrl()) && this.isBaseUrlConfigured() ? this.getBaseUrlString() + item.getResponseUrl() : item.getResponseUrl();
            urls.add(this.stringToUrl((String)temp));
        }
        return urls;
    }

    private URL stringToUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean isValidBindings() {
        for (ServiceEndpointItem item : this.endpoints) {
            String guiName = this.domainTranslator.toBindingGuiName(item.getBinding());
            if (guiName.equals(ARTIFACT) || guiName.equals("PAOS") || guiName.equals(POST) || guiName.equals(REDIRECT) || guiName.equals(SOAP)) continue;
            return false;
        }
        return true;
    }

    private boolean anyRelativeUrls() {
        for (URL endpoint : this.serviceEndpointItemToUrlList(this.endpoints)) {
            if (endpoint != null) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectionProtocol1x() {
        return this.protocol.equals((Object)Protocol.SAML10) || this.protocol.equals((Object)Protocol.SAML11);
    }

    public boolean getShowAdvanced() {
        return this.showAdvanced;
    }

    public void setShowAdvanced(boolean adv) {
        this.showAdvanced = adv;
    }

    public boolean isEditMode() {
        if (this.getAllowAdvanced()) {
            for (MessageCustomizationCard.MessageHookEntry entry : this.getMessageHooks().values()) {
                if (!entry.isEditing()) continue;
                return true;
            }
        }
        return false;
    }

    public String getAdvancedNote() {
        return "";
    }

    public boolean getIsEaAdmin() {
        AdministrativeUser currentUser = this.getCurrentUser();
        return currentUser == null || currentUser.isExpressionAdmin();
    }

    public boolean getAllowAdvanced() {
        return ExpressionManager.getInstance().isEvaluateExpressionsOn() && (this.getIsEaAdmin() || !this.getMessageHooks().isEmpty());
    }

    public boolean allowExpressionSave() {
        return this.getAllowAdvanced() && this.getIsEaAdmin();
    }
}

