/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.GlobalAuthnSessionPolicy;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class SessionValidationState
extends TaskletState {
    private boolean includeSessionIdentifier;
    private boolean checkValidAuthnSession;
    private boolean checkSessionRevocationStatus;
    private boolean updateAuthnSessionActivity;
    private boolean inheritSessionValidationSettings = true;
    private transient Object componentState;
    private final AuthnSessionPolicyManager sessionPolicyMgr = MgmtFactory.getAuthnSessionPolicyManager();

    public SessionValidationState(Tasklet value) {
        super(value);
        this.setMenuName("Session Validation");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.setComponentState(null);
        if (dataFromDisk != null) {
            BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataFromDisk;
            this.inheritSessionValidationSettings = pluginInstance.isInheritSessionValidationSettings();
            this.includeSessionIdentifier = pluginInstance.findEffectiveIncludeSessionIdentifier();
            this.checkSessionRevocationStatus = pluginInstance.findEffectiveRevocationStatus();
            this.checkValidAuthnSession = pluginInstance.findEffectiveSessionValidationStatus();
            this.updateAuthnSessionActivity = pluginInstance.findEffectiveUpdateSessionStatus();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataToDisk;
        pluginInstance.setInheritSessionValidationSettings(this.inheritSessionValidationSettings);
        if (this.inheritSessionValidationSettings) {
            pluginInstance.setIncludeSessionIdentifier(false);
            pluginInstance.setCheckSessionRevocationStatus(false);
            pluginInstance.setCheckSessionValidationStatus(false);
            pluginInstance.setUpdateAuthSessionActivity(false);
        } else {
            pluginInstance.setIncludeSessionIdentifier(this.includeSessionIdentifier);
            pluginInstance.setCheckSessionRevocationStatus(this.checkSessionRevocationStatus);
            pluginInstance.setCheckSessionValidationStatus(this.checkValidAuthnSession);
            pluginInstance.setUpdateAuthSessionActivity(this.updateAuthnSessionActivity);
        }
        return true;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.inheritSessionValidationSettings) {
            this.componentState = null;
            this.loadParentSessionValidationSettings();
        }
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Always Include Session Identifier In Access Token", new Boolean(this.includeSessionIdentifier).toString(), this));
        summaryList.add(new SummaryInfo("Check Session Validation Status", new Boolean(this.checkValidAuthnSession).toString(), this));
        summaryList.add(new SummaryInfo("Check Session Revocation Status", new Boolean(this.checkSessionRevocationStatus).toString(), this));
        summaryList.add(new SummaryInfo("Update Authentication Session Activity", new Boolean(this.updateAuthnSessionActivity).toString(), this));
    }

    public boolean isIncludeSessionIdentifier() {
        return this.includeSessionIdentifier;
    }

    public void setIncludeSessionIdentifier(boolean includeSessionIdentifier) {
        this.includeSessionIdentifier = includeSessionIdentifier;
    }

    public boolean isCheckValidAuthnSession() {
        return this.checkValidAuthnSession;
    }

    public void setCheckValidAuthnSession(boolean checkValidAuthnSession) {
        this.checkValidAuthnSession = checkValidAuthnSession;
    }

    public boolean isCheckSessionRevocationStatus() {
        return this.checkSessionRevocationStatus;
    }

    public void setCheckSessionRevocationStatus(boolean checkSessionRevocationStatus) {
        this.checkSessionRevocationStatus = checkSessionRevocationStatus;
    }

    public boolean isUpdateAuthnSessionActivity() {
        return this.updateAuthnSessionActivity;
    }

    public void setUpdateAuthnSessionActivity(boolean updateAuthnSessionActivity) {
        this.updateAuthnSessionActivity = updateAuthnSessionActivity;
    }

    public boolean hasParentInstance() {
        return this.getParentInstanceId() != null;
    }

    public String getParentInstanceId() {
        return this.getParent(PluginInstanceApi.class).getParentPluginInstanceId();
    }

    public boolean isInheritSessionValidationSettings() {
        return this.inheritSessionValidationSettings;
    }

    public void setInheritSessionValidationSettings(boolean inherit) {
        this.inheritSessionValidationSettings = inherit;
    }

    public boolean isOverrideSessionValidationSettings() {
        return !this.isInheritSessionValidationSettings();
    }

    public void setOverrideSessionValidationSettings(boolean override) {
        this.setInheritSessionValidationSettings(!override);
    }

    @Override
    public void onStateActivated() {
        if (!this.hasParentInstance()) {
            this.inheritSessionValidationSettings = false;
        }
        if (this.inheritSessionValidationSettings) {
            this.loadParentSessionValidationSettings();
        }
    }

    public boolean isShowWarning() {
        GlobalAuthnSessionPolicy globalPolicy = this.sessionPolicyMgr.getGlobalPolicy();
        boolean globalPolicyEnableSessions = globalPolicy.isEnableSessions();
        Collection policies = this.sessionPolicyMgr.getEnabledSourcePolicies();
        long enabledPolicies = policies.stream().filter(policy -> policy.isEnableSessions()).count();
        return !globalPolicyEnableSessions && enabledPolicies <= 0L;
    }

    private void loadParentSessionValidationSettings() {
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        BearerAccessTokenMgmtPluginInstance parentInstance = (BearerAccessTokenMgmtPluginInstance)pluginMgr.getInstance(this.getParentInstanceId());
        this.includeSessionIdentifier = parentInstance.findEffectiveIncludeSessionIdentifier();
        this.checkSessionRevocationStatus = parentInstance.findEffectiveRevocationStatus();
        this.checkValidAuthnSession = parentInstance.findEffectiveSessionValidationStatus();
        this.updateAuthnSessionActivity = parentInstance.findEffectiveUpdateSessionStatus();
    }
}

