/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.SmsProviderSettingsValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;

public class SmsProviderSettingsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String smsAccountId;
    private String smsAuthToken;
    private String smsFromNumber;

    public SmsProviderSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("SMS Provider Settings");
    }

    @Override
    public boolean populateAllStates(Object data) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        this.smsAccountId = settings.getSmsAccountId();
        this.smsAuthToken = settings.getSmsAuthToken();
        this.smsFromNumber = settings.getSmsFromNumber();
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        this.loadSettings(settings);
        notificationMgr.saveNotificationSettings(settings);
        return true;
    }

    private void loadSettings(NotificationSettings settings) {
        settings.setSmsAccountId(this.smsAccountId);
        settings.setSmsAuthToken(this.smsAuthToken);
        settings.setSmsFromNumber(this.smsFromNumber);
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate);
    }

    private void validate(IValidationDelegate delegate) {
        SmsProviderSettingsValidator validator = new SmsProviderSettingsValidator.Builder().setSmsAccountId(this.smsAccountId).setSmsAuthToken(this.smsAuthToken).setSmsFromNumber(this.smsFromNumber).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    public boolean isHasAdvancedFields() {
        return false;
    }

    public String getSmsAccountId() {
        return this.smsAccountId;
    }

    public void setSmsAccountId(String smsAccountId) {
        this.smsAccountId = smsAccountId;
    }

    public String getSmsAuthToken() {
        return this.smsAuthToken;
    }

    public void setSmsAuthToken(String smsAuthToken) {
        this.smsAuthToken = smsAuthToken;
    }

    public String getSmsFromNumber() {
        return this.smsFromNumber;
    }

    public void setSmsFromNumber(String smsFromNumber) {
        this.smsFromNumber = smsFromNumber;
    }
}

