/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.DefaultTargetUrlState;
import com.pingidentity.fsm.state.impl.LicenseGroupState;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.Source2TargetConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.issuancecriteria.impl.Source2TargetIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.util.List;
import java.util.Set;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.mgmt.Source2TargetManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public abstract class Source2TargetMappingTasklet<T extends Source2TargetMapping>
extends MappingTasklet
implements AttributeNamesApi {
    private static final long serialVersionUID = 1L;
    protected LicenseGroupState licenseGroupState;
    protected Source2TargetIssuanceCriteriaState issuanceCriteriaState;
    protected DefaultTargetUrlState defaultTargetUrlState;
    protected SummaryCardState summaryCardState;
    protected MappingState mappingFullfillmentState;
    protected ConfigurablePluginInstance sourceInstance;
    protected ConfigurablePluginInstance targetInstance;
    protected T s2tMapping;

    public Source2TargetMappingTasklet(String taskletName, String menuName, Visit visit) {
        super(taskletName, menuName);
        this.setSystemVisit(visit);
        this.setFinishAvailable(true);
        this.licenseGroupState = new LicenseGroupState(this);
        this.mappingFullfillmentState = this.buildMappingFullfillmentState();
        this.issuanceCriteriaState = new Source2TargetIssuanceCriteriaState(this);
        this.defaultTargetUrlState = new DefaultTargetUrlState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.createTransitions();
        if (LicenseManager.isConnectionGroupDefined()) {
            this.setInitialState(this.licenseGroupState);
        } else {
            this.setInitialState(this.configAttributeSourcesState);
        }
        this.setCancelAvailable(true);
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.loadMapping(this.copyMapping((Source2TargetMapping)dataFromDisk));
        this.populateFromCurrentMapping();
    }

    @Override
    public void cancel() {
        Object origData = this.getPopulateData();
        if (origData != null) {
            this.s2tMapping = (Source2TargetMapping)origData;
            T copiedData = this.copyMapping(this.s2tMapping);
            super.cancel();
            this.setPopulateData(copiedData);
        } else {
            super.cancel();
        }
    }

    protected void populateFromCurrentMapping() {
        super.populate(this.s2tMapping);
        if (!this.s2tMapping.isCountForLicense()) {
            this.setInitialState(this.configAttributeSourcesState);
        }
        this.setPopulateData(this.copyMapping(this.s2tMapping));
    }

    @Override
    public boolean save(Object dataToDisk) {
        Source2TargetMapping mapping = (Source2TargetMapping)dataToDisk;
        mapping.setSourceId(this.s2tMapping.getSourceId());
        mapping.setTargetId(this.s2tMapping.getTargetId());
        mapping.setCountForLicense(this.s2tMapping.isCountForLicense());
        boolean result = super.save(mapping);
        return result;
    }

    protected void createTransitions() {
        this.licenseGroupState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.defaultTargetUrlState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public void finish() {
        Source2TargetMapping populateData = this.getSource2TargetManager().createEmptyMapping();
        if (this.save(populateData)) {
            this.getSource2TargetManager().saveMapping(populateData);
            String mappingId = ApiUtil.combineId((String)populateData.getSourceId(), (String)populateData.getTargetId());
            MgmtFactory.getDependencyErrorManager().remove(mappingId, this.getAffectedItemType());
        }
        super.finish();
        Source2TargetMapping mapping = populateData;
        mapping.setSourceId(this.s2tMapping.getSourceId());
        mapping.setTargetId(this.s2tMapping.getTargetId());
        this.setPopulateData(populateData);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    public T getSource2TargetMapping() {
        return this.s2tMapping;
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.targetInstance.getAttributeContract().getAllAttributeNames();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.targetInstance.getAttributeContract().getAllAttrNamesSorted();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.targetInstance.getAttributeContract().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.targetInstance.getAttributeContract().getSortedMutableAttributeNames();
    }

    public String getLicensedText() {
        String licensedText = "";
        if (LicenseManager.getLicense().getConnectionLimit() != null && this.s2tMapping.isCountForLicense()) {
            licensedText = " (Licensed) ";
        }
        return licensedText;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.sourceInstance;
    }

    public List<String> getContractToFulfill() {
        return this.targetInstance.getAttributeContract().getAllAttrNamesSorted();
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new Source2TargetConfigAttributeSourcesState(this, "configAttributeSources");
    }

    public String getDescription() {
        return "'" + this.sourceInstance.getName() + "' to '" + this.targetInstance.getName() + "'";
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getDescription().toLowerCase().compareTo(((Source2TargetMappingTasklet)o).getDescription().toLowerCase());
    }

    @Override
    public abstract String getNoteKeySuffix();

    @Override
    public abstract String getMappingSourceForDisplay();

    public abstract MappingState buildMappingFullfillmentState();

    public abstract void loadMapping(T var1);

    public abstract void addStandardSourcesToPropertySelectionSources(DataMap.Sources var1);

    public abstract T copyMapping(T var1);

    public abstract Source2TargetManager<T> getSource2TargetManager();

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.mappingFullfillmentState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.issuanceCriteriaState.getIssuanceCriteriaList();
    }

    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.SOURCE_TO_TARGET;
    }

    public void deleteMapping() {
        Source2TargetMapping mapping = (Source2TargetMapping)this.getPopulateData();
        this.getSource2TargetManager().deleteMapping(mapping);
        String mappingId = ApiUtil.combineId((String)mapping.getSourceId(), (String)mapping.getTargetId());
        MgmtFactory.getDependencyErrorManager().remove(mappingId, this.getAffectedItemType());
    }
}

