/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collection;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.util.license.LicenseManager;

@AutoSaveState
public abstract class Source2TargetMappingsState<T extends Source2TargetMapping>
extends TaskletListState {
    private static final long serialVersionUID = 1L;
    private ConfigurablePluginInstance selectedSource;
    private ConfigurablePluginInstance selectedTarget;

    public Source2TargetMappingsState(Tasklet owner) {
        super(owner);
        this.setMenuName("Manage Mappings");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        Collection<T> mappings = this.populateSource2TargetMappings();
        for (Source2TargetMapping mapping : mappings) {
            Source2TargetMappingTasklet<T> adapterMappingTasklet = this.createTasklet(this.getMappingTaskletClass());
            adapterMappingTasklet.setMode(Mode.edit);
            adapterMappingTasklet.populate(mapping);
            adapterMappingTasklet.setFinishLabel("Save");
            this.addTasklet(adapterMappingTasklet);
        }
        this.sort();
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        Source2TargetMappingTasklet tasklet = (Source2TargetMappingTasklet)this.getTasklet(taskletToDelete);
        tasklet.setItDeleted(true);
        tasklet.deleteMapping();
    }

    protected IPropertySelectionModel toSelectionModel(Collection<? extends ConfigurablePluginInstance> instances) {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (ConfigurablePluginInstance configurablePluginInstance : instances) {
            if (configurablePluginInstance.getDescriptor() == null) continue;
            model.add(configurablePluginInstance.getName(), configurablePluginInstance);
        }
        model.sort();
        return model;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        for (Tasklet tasklet : this.getTasklets()) {
            if (tasklet.isItDeleted()) continue;
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            Source2TargetMappingTasklet mappingTasklet = (Source2TargetMappingTasklet)tasklet;
            Object[] params = new Object[]{mappingTasklet.sourceInstance.getId(), mappingTasklet.targetInstance.getId()};
            delegate.record(this.getMessage("mapping_has_errors", params), ValidationConstraint.REQUIRED);
        }
    }

    public ConfigurablePluginInstance getSelectedSource() {
        return this.selectedSource;
    }

    public void setSelectedSource(ConfigurablePluginInstance selectedSource) {
        this.selectedSource = selectedSource;
    }

    public ConfigurablePluginInstance getSelectedTarget() {
        return this.selectedTarget;
    }

    public void setSelectedTarget(ConfigurablePluginInstance selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public boolean isConnectionGroupDefined() {
        return LicenseManager.isConnectionGroupDefined();
    }

    public boolean containsMapping(String sourceId, String targetId) {
        for (Tasklet t : this.getTasklets()) {
            Source2TargetMappingTasklet mappingTasklet = (Source2TargetMappingTasklet)t;
            Object mapping = mappingTasklet.getSource2TargetMapping();
            if (!mapping.getSourceId().equals(sourceId) || !mapping.getTargetId().equals(targetId)) continue;
            return true;
        }
        return false;
    }

    public abstract Collection<T> populateSource2TargetMappings();

    public abstract Class<? extends Source2TargetMappingTasklet<T>> getMappingTaskletClass();

    public abstract IPropertySelectionModel getSourceInstances();

    public abstract IPropertySelectionModel getTargetInstances();

    public abstract String getMappingsHeaderText();

    public abstract String getMessageKeyPrefix();

    public abstract T makeMapping();
}

