/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpProtocolSettingsTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.websso.Protocol;

public class SpSignaturePolicyState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private SpConnection spConnection;
    private boolean authnRequestsSigned;
    private boolean signResponseAsRequired;
    private boolean alwaysSignAssertion;
    private boolean alwaysSignArtifactResponse;

    public SpSignaturePolicyState(Tasklet value) {
        super(value);
        this.setMenuName("Signature Policy");
    }

    @Override
    public void onStateActivated() {
        if (this.isShowAuthnRequestsSigned()) {
            this.setNoteKey(null);
        } else {
            this.setNoteKey(this.getTaskletStateId() + "_NoSignedAuthnRequests");
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.spConnection = (SpConnection)dataFromDisk;
        this.authnRequestsSigned = this.spConnection.isAuthnRequestsSigned();
        this.signResponseAsRequired = this.spConnection.isSignResponseAsRequired();
        this.alwaysSignAssertion = this.spConnection.isWantAssertionsSigned();
        this.alwaysSignArtifactResponse = this.spConnection.isAlwaysSignArtifactResponse();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ((SpConnection)dataToDisk).setAuthnRequestsSigned(this.authnRequestsSigned);
        ((SpConnection)dataToDisk).setWantAssertionsSigned(this.isAlwaysSignAssertion());
        ((SpConnection)dataToDisk).setSignResponseAsRequired(Boolean.valueOf(this.isSignResponseAsRequired()));
        ((SpConnection)dataToDisk).setAlwaysSignArtifactResponse(this.isAlwaysSignArtifactResponse());
        return true;
    }

    @Override
    public void reset() {
        this.authnRequestsSigned = false;
        this.signResponseAsRequired = true;
        this.alwaysSignAssertion = false;
        this.alwaysSignArtifactResponse = false;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.isShowAuthnRequestsSigned()) {
            summaryList.add(new SummaryInfo(this.getMessage("Authn_Requests_Signed"), Boolean.toString(this.authnRequestsSigned), this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Always_Sign_Assertion"), Boolean.valueOf(this.alwaysSignAssertion).toString(), this));
        if (this.isSAML20()) {
            summaryList.add(new SummaryInfo(this.getMessage("Sign_Response_As_Required"), Boolean.valueOf(this.isSignResponseAsRequired()).toString(), this));
        }
        if (this.isShowAlwaysSignArtifact()) {
            summaryList.add(new SummaryInfo(this.getMessage("Always_Sign_ArtifactResponse"), Boolean.toString(this.alwaysSignArtifactResponse), this));
        }
    }

    public boolean isAuthnRequestsSigned() {
        return this.authnRequestsSigned;
    }

    public void setAuthnRequestsSigned(boolean authnRequestsSigned) {
        this.authnRequestsSigned = authnRequestsSigned;
    }

    public boolean isShowAuthnRequestsSigned() {
        return this.findParent(MultiProtocolTasklet.class).isConnectionProtocol20() && !this.findParent(SamlProfilesApi.class).onlyIdpSsoSelected();
    }

    public boolean isSignResponseAsRequired() {
        return !this.isSAML20() || !this.isAlwaysSignAssertion() || this.signResponseAsRequired;
    }

    public void setSignResponseAsRequired(boolean signResponseAsRequired) {
        this.signResponseAsRequired = signResponseAsRequired;
    }

    public boolean isAlwaysSignAssertion() {
        return this.alwaysSignAssertion;
    }

    public void setAlwaysSignAssertion(boolean alwaysSignAssertion) {
        this.alwaysSignAssertion = alwaysSignAssertion;
    }

    public boolean isSAML20() {
        SpProtocolSettingsTasklet parent = this.findParent(SpProtocolSettingsTasklet.class);
        return parent.getProtocolType() != null && parent.getProtocolType().equals((Object)Protocol.SAML20);
    }

    public boolean isShowEnabledSignResponseAsRequiredCheckbox() {
        return this.isSAML20() && this.isAlwaysSignAssertion();
    }

    public boolean isShowDisabledSignResponseAsRequiredCheckbox() {
        return this.isSAML20() && !this.isAlwaysSignAssertion();
    }

    public void setAlwaysSignArtifactResponse(boolean alwaysSignArtifactResponse) {
        this.alwaysSignArtifactResponse = alwaysSignArtifactResponse;
    }

    public boolean isAlwaysSignArtifactResponse() {
        return this.alwaysSignArtifactResponse;
    }

    public boolean isShowAlwaysSignArtifact() {
        SpProtocolSettingsTasklet parent = this.findParent(SpProtocolSettingsTasklet.class);
        return parent != null && (parent.isArtifactSsoSlo() || parent.isInboundArtifact());
    }
}

