/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.SourceContextType;

public class SpXaspAttributeSourceMappingState
extends MappingState {
    private static final long serialVersionUID = 1L;

    public SpXaspAttributeSourceMappingState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Mapping Fulfillment");
        this.model.setTargetName("Attribute Contract");
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeRequester attributeRequester = (AttributeRequester)dataFromDisk;
        this.attributeMapping = attributeRequester.getAttributeMapping();
        this.model = new SAML2MappingModel("Attribute Contract", this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeRequester tempAttributeRequester = (AttributeRequester)dataToDisk;
        AttributeMapping outmap = tempAttributeRequester.getAttributeMapping();
        outmap.setAttributeMap(this.model.getMapping().getAttributeMap());
        return true;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.sources.setValidateTextField(false);
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForSpXasp()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        this.sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    @Override
    public void reset() {
        this.model = new SAML2MappingModel(this.getCurrentUser());
    }

    public List<String> getTarget() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }
}

