/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.InCertAuthInfo;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SslCertVerificationState
extends CertificateState {
    private static final long serialVersionUID = 20050515L;
    private Set<Cert> verificationCerts;

    public SslCertVerificationState(Tasklet value) {
        super(value);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        ConnectionCerts clientAuthCerts = connection.getClientAuthCerts();
        this.verificationCerts = clientAuthCerts.getAllVerificationCerts();
        this.setSelectedCert(clientAuthCerts.getActiveVerificationCert());
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        ConnectionCerts connectionCerts = new ConnectionCerts();
        connectionCerts.setVerificationCerts((ArrayList)(this.getSelectedCert() == null ? null : new ArrayList<Cert>(Collections.singletonList(this.getSelectedCert()))), this.verificationCerts);
        tempConnection.getSoapAuthIn().setCertAuthInfo((SoapAuthInfo.CertAuthInfo)new InCertAuthInfo(connectionCerts));
        return true;
    }

    @Override
    public void reset() {
        if (this.verificationCerts != null && !this.verificationCerts.isEmpty()) {
            this.verificationCerts.clear();
        }
    }

    @Override
    protected Object getObjectForPopulate() {
        return this.verificationCerts;
    }

    @Override
    public void refreshState() {
        CertManagementTasklet tasklet = (CertManagementTasklet)this.getTaskletToEdit();
        this.setSelectedCert(tasklet.getSelectedCert());
        this.verificationCerts = tasklet.getSslVerificationCerts();
    }

    public Set<Cert> getVerificationCerts() {
        return this.verificationCerts;
    }

    public void setVerificationCerts(Set<Cert> verificationCerts) {
        this.verificationCerts = verificationCerts;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getSelectedCert() == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Cert_required"), ValidationConstraint.REQUIRED);
        } else {
            ConnectionManager connManager = MgmtFactory.getConnectionManager();
            ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
            ConnectionBase conn = connTasklet.getBase();
            String ctxId = conn == null ? null : conn.getId();
            String usedBy = connManager.certAuthInCertUsedBy(this.getSelectedCert(), ctxId);
            if (usedBy != null) {
                delegate.setFormComponent(null);
                Object[] params = new String[]{usedBy};
                delegate.record(this.getMessage("cert_in_use", params), ValidationConstraint.REQUIRED);
            }
        }
    }
}

