/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpConnection;

public class SsoServiceUrlState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String endpoint;

    public SsoServiceUrlState(Tasklet parent) {
        super(parent);
        this.setMenuName("SSO Service URL");
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection idp = (IdpConnection)dataFromDisk;
        EndpointGroup singleSignOnServices = idp.getSingleSignOnServices();
        Endpoint isxEndpont = singleSignOnServices.getPrimaryEndpoint();
        this.endpoint = isxEndpont == null ? "" : isxEndpont.getLocation();
    }

    @Override
    public boolean save(Object dataToSave) {
        IdpConnection tempConnection = (IdpConnection)dataToSave;
        Endpoint newEndpoint = new Endpoint("DestinationSiteFirstBinding:simple:http:302", this.endpoint);
        EndpointGroup singleSignOnServices = new EndpointGroup(newEndpoint);
        tempConnection.setSingleSignOnServices(singleSignOnServices);
        return true;
    }

    @Override
    public void reset() {
        this.endpoint = "";
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        StringBuilder sb = new StringBuilder();
        sb.append("URL: ").append(this.endpoint);
        summaryList.add(new SummaryInfo(this.getMessage("Endpoint"), sb.toString(), this));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.endpoint)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Endpoint_required"), ValidationConstraint.REQUIRED);
        } else if (!ValidationUtil.isValidHttpOrHttpsUrl((String)this.endpoint)) {
            if (this.isBaseUrlConfigured()) {
                if (!ValidationUtil.startsWithForwardSlash((String)this.endpoint)) {
                    delegate.record(this.getMessage("Common", "Endpoint_base_url_malformed"), ValidationConstraint.URL_FORMAT);
                }
            } else {
                delegate.record(this.getMessage("Common", "Malformed_url"), ValidationConstraint.URL_FORMAT);
            }
        }
    }

    private boolean isBaseUrlConfigured() {
        boolean isBaseUrlConfigured = false;
        Tasklet t = this.findParent(ConnectionTasklet.class);
        if (t != null && t instanceof ConnectionTasklet) {
            ConnectionTasklet c = (ConnectionTasklet)t;
            isBaseUrlConfigured = c.isBaseUrlConfigured();
        }
        return isBaseUrlConfigured;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = StringUtils.stripToEmpty((String)endpoint);
    }
}

