/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class SubjectDnState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String subjectDn = null;
    private boolean restrictIssuer = true;
    private String issuerDn = null;

    public SubjectDnState(Tasklet value) {
        super(value);
        this.setMenuName("Subject DN");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connectionBase = (ConnectionBase)dataFromDisk;
        this.subjectDn = connectionBase.getSoapAuthIn().getCertAuthInfo().getSubjectDN();
        this.issuerDn = connectionBase.getSoapAuthIn().getCertAuthInfo().getIssuerDN();
        this.restrictIssuer = !StringUtils.isBlank((String)this.issuerDn);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase conn = (ConnectionBase)dataToDisk;
        SoapAuthInfo soapAuthIn = conn.getSoapAuthIn();
        String effectiveIssuerDn = null;
        if (this.restrictIssuer) {
            effectiveIssuerDn = this.issuerDn;
        }
        soapAuthIn.setCertAuthInfo(new SoapAuthInfo.CertAuthInfo(this.subjectDn, effectiveIssuerDn, null, null));
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Subject_dn"), this.getSubjectDn(), this));
        if (this.restrictIssuer) {
            summaryList.add(new SummaryInfo(this.getMessage("Issuer_dn"), this.getIssuerDn(), this));
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!ValidationUtil.isValidSubjectDN((String)this.getSubjectDn())) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Subject_dn_required"), ValidationConstraint.REQUIRED);
        } else {
            ConnectionManager connManager = MgmtFactory.getConnectionManager();
            ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
            ConnectionBase conn = connTasklet.getBase();
            String ctxId = conn == null ? null : conn.getId();
            String usedBy = connManager.certAuthInSubjectDbUsedBy(this.getSubjectDn(), ctxId);
            if (usedBy != null) {
                delegate.setFormComponent(null);
                Object[] params = new String[]{usedBy};
                delegate.record(this.getMessage("dn_in_use", params), ValidationConstraint.REQUIRED);
            }
        }
        if (this.restrictIssuer) {
            if (!ValidationUtil.isValidSubjectDN((String)this.getIssuerDn())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Issuer_dn_required"), ValidationConstraint.REQUIRED);
            } else {
                TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
                if (trustedCAsManager.getTrustAnchorsByDN(new X500Principal(this.getIssuerDn())).isEmpty()) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Issuer_dn_not_a_trust_anchor"), ValidationConstraint.REQUIRED);
                }
            }
        }
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public void setSubjectDn(String subjectDn) {
        this.subjectDn = subjectDn;
    }

    public String getIssuerDn() {
        return this.issuerDn;
    }

    public void setIssuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
    }

    public boolean isRestrictIssuer() {
        return this.restrictIssuer;
    }

    public void setRestrictIssuer(boolean restrictIssuer) {
        this.restrictIssuer = restrictIssuer;
    }

    @Override
    public void reset() {
        this.subjectDn = null;
        this.issuerDn = null;
        this.restrictIssuer = false;
    }
}

