/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.EmailValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SystemInfoState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String company;
    private String contactName;
    private String contactNumber;
    private String contactEmail;

    public SystemInfoState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("System Info");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        ContactInfo cinfo = localSettings.getContactInfo();
        if (cinfo != null) {
            this.company = cinfo.getCompany();
            this.contactNumber = cinfo.getPhone();
            this.contactEmail = cinfo.getEmail();
            String firstname = cinfo.getFirstName() == null ? "" : cinfo.getFirstName();
            String lastname = cinfo.getLastName() == null ? "" : cinfo.getLastName();
            this.contactName = firstname.trim() + " " + lastname.trim();
        }
    }

    @Override
    public boolean save(Object dataFromDisk) {
        String[] name = this.parseContactName();
        ContactInfo cinfo = new ContactInfo();
        cinfo.setCompany(this.company);
        cinfo.setFirstName(name[0]);
        cinfo.setLastName(name[1]);
        cinfo.setPhone(this.contactNumber);
        cinfo.setEmail(this.contactEmail);
        LocalSettings localSettings = (LocalSettings)dataFromDisk;
        localSettings.setContactInfo(cinfo);
        return true;
    }

    private String[] parseContactName() {
        String[] result = new String[2];
        if (this.contactName != null) {
            String[] names = this.contactName.trim().split(" ", 2);
            if (names.length > 0) {
                result[0] = names[0];
            }
            if (names.length > 1) {
                result[1] = names[1];
            }
        }
        return result;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        EmailValidator validator = new EmailValidator(this.contactEmail, ApiMessageKey.system_info_email_invalid);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (!StringUtils.isBlank((String)this.company)) {
            summaryList.add(new SummaryInfo(this.getMessage("My_company_name"), this.getCompany(), this));
        }
        if (!StringUtils.isBlank((String)this.contactName)) {
            summaryList.add(new SummaryInfo(this.getMessage("Contact_name"), this.getContactName(), this));
        }
        if (!StringUtils.isBlank((String)this.contactNumber)) {
            summaryList.add(new SummaryInfo(this.getMessage("Contact_number"), this.getContactNumber(), this));
        }
        if (!StringUtils.isBlank((String)this.contactEmail)) {
            summaryList.add(new SummaryInfo(this.getMessage("Contact_email"), this.getContactEmail(), this));
        }
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    @Override
    public void reset() {
        this.populate(null);
    }
}

