/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PFInternalTokenSettingsManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.token.PFInternalTokenSetting;
import org.sourceid.token.jwt.PFInternalJwtTokenSettings;
import org.sourceid.token.jwt.SystemKey;
import org.sourceid.websso.servlet.BaseSessionIdUtil;
import org.sourceid.websso.servlet.PersistentSessionIdUtil;

public class SystemKeysState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private transient SystemKey currentKey;
    private transient SystemKey previousKey;
    private transient SystemKey pendingKey;
    private boolean keysRotated = false;
    private boolean rotateRequested = false;
    private static final PFInternalTokenSettingsManager pFInternalTokenSettingsManager = MgmtFactory.getPFInternalTokenSettingsManager();

    public SystemKeysState(Tasklet parent) {
        super(parent);
        this.setMenuName("System Keys");
    }

    public SystemKey getPendingKey() {
        return this.pendingKey;
    }

    public SystemKey getCurrentKey() {
        return this.currentKey;
    }

    public SystemKey getPreviousKey() {
        return this.previousKey;
    }

    public void setPendingKey(SystemKey pendingKey) {
        this.pendingKey = pendingKey;
    }

    public void setPreviousKey(SystemKey previousKey) {
        this.previousKey = previousKey;
    }

    public void setCurrentKey(SystemKey currentKey) {
        this.currentKey = currentKey;
    }

    @Override
    public void populate(Object dataFromDisk) {
        PFInternalTokenSetting systemKeys = pFInternalTokenSettingsManager.getPFInternalTokenSettings();
        this.currentKey = systemKeys.getCurrentKey();
        this.previousKey = systemKeys.getPreviousKey();
        this.pendingKey = systemKeys.getPendingKey();
    }

    @Override
    public void reset() {
        this.keysRotated = false;
        this.rotateRequested = false;
    }

    @Override
    public boolean save(Object dataToDisk) {
        PFInternalJwtTokenSettings systemKeys = new PFInternalJwtTokenSettings(this.currentKey, this.previousKey, this.pendingKey);
        pFInternalTokenSettingsManager.savePFInternalTokenSettings((PFInternalTokenSetting)systemKeys);
        return true;
    }

    public boolean isPreviousKeyExists() {
        return this.previousKey != null;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Pending Key Creation Time", this.pendingKey.getCreationDate().toString(), this));
        summaryList.add(new SummaryInfo("Current Key Creation Time", this.currentKey.getCreationDate().toString(), this));
        if (this.previousKey != null) {
            summaryList.add(new SummaryInfo("Previous Key Creation Time", this.previousKey.getCreationDate() == null ? "" : this.previousKey.getCreationDate().toString(), this));
        }
    }

    public void onRotate() {
        if (this.isConfirmationRequired()) {
            this.rotateRequested = true;
        } else {
            this.doRotate();
        }
    }

    public void onConfirmRotate() {
        this.doRotate();
    }

    public void onCancelRotate() {
        this.rotateRequested = false;
    }

    public String getRotateConfirmationMsg() {
        if (this.previousKey != null) {
            return this.getMessage("Rotate_confirmation_msg", new Object[]{this.previousKey.getCreationDate().toString()});
        }
        return null;
    }

    public boolean getShowRotateConfirmationMsg() {
        return this.rotateRequested;
    }

    public boolean getShowRotateCompleteMsg() {
        return this.keysRotated;
    }

    public boolean getRotateEnabled() {
        return !this.rotateRequested && !this.keysRotated;
    }

    private boolean isConfirmationRequired() {
        if (!MgmtFactory.getAuthnSessionPolicyManager().isAnyStoredSessionEnabled()) {
            return false;
        }
        if (PersistentSessionIdUtil.getInstance().getFormat() != BaseSessionIdUtil.Format.JWT) {
            return false;
        }
        if (this.previousKey == null) {
            return false;
        }
        Duration diff = Duration.between(this.previousKey.getCreationDate().toInstant(), Instant.now());
        return diff.toMinutes() < (long)MgmtFactory.getAuthnSessionPolicyManager().getLongestStoredSessionIdleTimeoutMins();
    }

    private void doRotate() {
        SystemKey newPendingKey = MgmtFactory.getPFInternalTokenSettingsManager().generateSystemKey();
        this.setPreviousKey(this.getCurrentKey());
        this.setCurrentKey(this.getPendingKey());
        this.setPendingKey(newPendingKey);
        this.rotateRequested = false;
        this.keysRotated = true;
    }

    public boolean isReplicationRequired() {
        Mediator mediator = MgmtFactory.getMediator();
        if (!mediator.isStandalone()) {
            Date pendingKeyCreationTime = this.getPendingKey().getCreationDate();
            Date configPublishDate = mediator.getConfigPublishDate();
            if (pendingKeyCreationTime == null || configPublishDate == null) {
                return true;
            }
            return pendingKeyCreationTime.after(configPublishDate);
        }
        return false;
    }
}

