/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.Token2TokenMappingState;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.a2a.domain.mgmt.Source2TargetManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class Token2TokenMappingTasklet
extends Source2TargetMappingTasklet<Token2TokenMapping> {
    private static final long serialVersionUID = 1L;

    public Token2TokenMappingTasklet(Visit visit) {
        super("Token2TokenMappingTasklet", "Mapping Configuration", visit);
    }

    @Override
    public void loadMapping(Token2TokenMapping mapping) {
        this.s2tMapping = mapping;
        this.sourceInstance = MgmtFactory.getTokenProcessorManager().getInstance(mapping.getSourceId());
        this.targetInstance = MgmtFactory.getTokenGeneratorManager().getInstance(mapping.getTargetId());
    }

    @Override
    public MappingState buildMappingFullfillmentState() {
        return new Token2TokenMappingState(this, "mapping");
    }

    @Override
    public String getNoteKeySuffix() {
        return "T2T";
    }

    @Override
    public String getMappingSourceForDisplay() {
        return "Token";
    }

    @Override
    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        ConfigurablePluginInstance sourceInstance = this.getSelectedPlugin();
        List srcNames = sourceInstance.getAttributeContract().getAllAttrNamesSorted();
        sources.addPropertySelectionSource("Token", new StringPairPropertySelectionModel(true, srcNames));
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForSource2Target()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    @Override
    protected void createTransitions() {
        this.licenseGroupState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public Token2TokenMapping copyMapping(Token2TokenMapping mapping) {
        return new Token2TokenMapping(mapping);
    }

    @Override
    public Source2TargetManager<Token2TokenMapping> getSource2TargetManager() {
        return MgmtFactory.getToken2TokenManager();
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.TOKEN_TRANSLATOR_MAPPING;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }
}

