/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.TrackedHttpParamsSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrackedHttpParamManager;

public class TrackedHttpParamsState
extends TaskletState
implements TableEditor.TableEditorListener {
    private final SimpleFieldDescriptor WHITE_LIST_PARAM_NAME = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Parameter Name", 240);
    private final List<SimpleFieldDescriptor> descriptors = new ArrayList<SimpleFieldDescriptor>();
    private List<TableRow> whiteListParams = new ArrayList<TableRow>();
    private Object componentState;
    private boolean isPopulated;

    public TrackedHttpParamsState(IWizard owner) {
        super(owner);
        this.setMenuName("Tracked HTTP Parameters");
        this.descriptors.add(this.WHITE_LIST_PARAM_NAME);
    }

    @Override
    public void populate(Object dataFromDisk) {
        TrackedHttpParamManager trackedHttpParamManager = MgmtFactory.getTrackedHttpParamManager();
        TrackedHttpParamsSettings settings = trackedHttpParamManager.getTrackedParamSettings();
        this.whiteListParams = this.createRowsFromDisk(settings.getTrackedParamNames());
        this.isPopulated = true;
        super.populate(dataFromDisk);
    }

    @Override
    public boolean save(Object dataToDisk) {
        TrackedHttpParamsSettings settings = this.createTrackedParamSettings();
        TrackedHttpParamManager trackedHttpParamManager = MgmtFactory.getTrackedHttpParamManager();
        trackedHttpParamManager.saveTrackedParamSettings(settings);
        return super.save(dataToDisk);
    }

    public TrackedHttpParamsSettings createTrackedParamSettings() {
        return new TrackedHttpParamsSettings(this.getParamsFromRows());
    }

    private List<TableRow> createRowsFromDisk(List<String> params) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        params.forEach(param -> {
            ArrayList<FieldItem> items = new ArrayList<FieldItem>();
            items.add(new FieldItem(this.WHITE_LIST_PARAM_NAME, (String)param));
            rows.add(new TableRow(items));
        });
        return rows;
    }

    private List<String> getParamsFromRows() {
        ArrayList<String> params = new ArrayList<String>(this.whiteListParams.size());
        this.whiteListParams.forEach(row -> {
            if (!row.isMarkedForDelete()) {
                params.add(this.getParamNameFromRow((TableRow)row));
            }
        });
        return params;
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.isPopulated = false;
        this.setComponentState(null);
    }

    private String getParamNameFromRow(TableRow row) {
        return row.getFields().get(0).getValue().trim();
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        String paramToAdd = this.getParamNameFromRow(row);
        if (StringUtils.isBlank((String)paramToAdd)) {
            errors.add(this.getMessage("blank_value"));
        }
        for (TableRow currentRow : list) {
            if (currentRow.equals(originalRow) || !paramToAdd.equals(this.getParamNameFromRow(currentRow))) continue;
            errors.add(this.getMessage("duplicate_name", new Object[]{paramToAdd}));
        }
        return errors;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<TableRow> getWhiteListParams() {
        return this.whiteListParams;
    }

    public void setWhiteListParams(List<TableRow> whiteListParams) {
        this.whiteListParams = whiteListParams;
    }

    public List<SimpleFieldDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public boolean isPopulated() {
        return this.isPopulated;
    }
}

