/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;

public abstract class UrlWhitelistState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final long serialVersionUID = 1L;
    protected List<TableRow> whitelist = new ArrayList<TableRow>();
    private transient Object componentState;
    private static final SimpleFieldDescriptor REQUIRE_HTTPS = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Require HTTPS", 120, false, "true");
    private static final SimpleFieldDescriptor VALID_DOMAIN_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Valid Domain Name (leading wildcard '*.' allowed)", 200);
    private static final SimpleFieldDescriptor VALID_PATH_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Valid Path (leave blank to allow any path)", 275);
    private static final SimpleFieldDescriptor ALLOW_QUERY_FRAGMENT_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Allow Any Query/Fragment", 120);
    private static final List<SimpleFieldDescriptor> WHITELIST_COLUMN_DESCRIPTORS = Arrays.asList(REQUIRE_HTTPS, VALID_DOMAIN_DESC, VALID_PATH_DESC, ALLOW_QUERY_FRAGMENT_DESC);
    protected static final TargetResourceValidationMgr targetResourceValidationMgr = (TargetResourceValidationMgr)GlobalRegistry.getService(TargetResourceValidationMgr.class);

    public UrlWhitelistState(Tasklet parent) {
        super(parent);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        this.whitelist = this.loadWhitelist(connection);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        if (this.isShowWhitelistTable()) {
            tempConnection.setRedirectValidationWhitelist(this.makeRedirectValidationWhitelist());
        } else {
            tempConnection.setRedirectValidationWhitelist(new ArrayList());
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.isShowWhitelistTable()) {
            List<UrlWhitelistEntry> domains = this.makeRedirectValidationWhitelist();
            int index = 1;
            int size = domains.size();
            for (UrlWhitelistEntry entry : domains) {
                String domainIndex = size > 1 ? String.valueOf(index++) : "";
                SummaryInfo domainInfo = new SummaryInfo("Domain " + domainIndex, null, this);
                domainInfo.setBold(true);
                summaryList.add(domainInfo);
                summaryList.add(new SummaryInfo("Allowed Domain/Path", entry.getValidDomain() + StringUtils.defaultString((String)entry.getValidPath()), this));
                summaryList.add(new SummaryInfo("Require HTTPS", Boolean.toString(entry.isRequireHttps()), this));
                summaryList.add(new SummaryInfo("Allow Any Query/Fragment", Boolean.toString(entry.isAllowQueryAndFragment()), this));
            }
        }
    }

    public List<SimpleFieldDescriptor> getWhitelistColumnDescriptors() {
        return WHITELIST_COLUMN_DESCRIPTORS;
    }

    public List<TableRow> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(List<TableRow> whitelist) {
        this.whitelist = whitelist;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public abstract boolean isShowWhitelistTable();

    @Override
    public List<String> validate(TableRow updatedRow, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(targetResourceValidationMgr.validateDomain(this.getValidDomain(updatedRow)));
        errors.addAll(targetResourceValidationMgr.validatePath(this.getValidPath(updatedRow), this.getAllowQueryFragment(updatedRow)));
        return errors;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow newRow) {
    }

    protected List<TableRow> loadWhitelist(ConnectionBase connBase) {
        ArrayList<TableRow> result = new ArrayList<TableRow>();
        if (connBase.getRedirectValidationWhitelist() != null) {
            for (UrlWhitelistEntry entry : connBase.getRedirectValidationWhitelist()) {
                ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
                fields.add(new FieldItem(REQUIRE_HTTPS, Boolean.toString(entry.isRequireHttps())));
                fields.add(new FieldItem(VALID_DOMAIN_DESC, entry.getValidDomain()));
                fields.add(new FieldItem(VALID_PATH_DESC, entry.getValidPath()));
                fields.add(new FieldItem(ALLOW_QUERY_FRAGMENT_DESC, Boolean.toString(entry.isAllowQueryAndFragment())));
                TableRow row = new TableRow(fields);
                result.add(row);
            }
        }
        return result;
    }

    protected List<UrlWhitelistEntry> makeRedirectValidationWhitelist() {
        ArrayList<UrlWhitelistEntry> list = new ArrayList<UrlWhitelistEntry>();
        for (TableRow row : this.getWhitelist()) {
            if (row.isMarkedForDelete()) continue;
            UrlWhitelistEntry entry = new UrlWhitelistEntry(this.getValidDomain(row), this.getValidPath(row), this.getAllowQueryFragment(row), this.getRequireHttps(row));
            list.add(entry);
        }
        return list;
    }

    protected boolean getRequireHttps(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(0).getValue().trim());
    }

    protected String getValidDomain(TableRow row) {
        return row.getFields().get(1).getValue().trim();
    }

    protected String getValidPath(TableRow row) {
        return row.getFields().get(2).getValue().trim();
    }

    protected boolean getAllowQueryFragment(TableRow row) {
        return Boolean.parseBoolean(row.getFields().get(3).getValue().trim());
    }
}

