/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.IdpConnection;

public class UserAttributesState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final String ADDITIONAL_VALUES = "ADDITIONAL_VALUES";
    private static final String ASSERTION_ONLY = "ASSERTION_ONLY";
    private List<String> attributeContractList = new ArrayList<String>();
    private String selectedAttributeSource = "ASSERTION_ONLY";

    public UserAttributesState(Tasklet value) {
        super(value);
        this.setMenuName("User Attributes");
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection c = (IdpConnection)dataFromDisk;
        this.selectedAttributeSource = c.getUserProvisioning() != null && c.getUserProvisioning().isDoAttributeQuery() ? ADDITIONAL_VALUES : ASSERTION_ONLY;
        this.onStateActivated();
    }

    @Override
    public void onStateActivated() {
        AttributeNamesApi ana = this.findParent(AttributeNamesApi.class);
        this.attributeContractList = ana.getAllAttrNamesSorted();
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
            this.getParent().reconfigureTransitions(this);
        }
    }

    public String getIncludeAdditionalAttributes() {
        return this.selectedAttributeSource;
    }

    public void setIncludeAdditionalAttributes(String selectedAttributeSource) {
        if (!this.selectedAttributeSource.equals(selectedAttributeSource)) {
            this.selectedAttributeSource = selectedAttributeSource;
            this.getParent().reconfigureTransitions(this);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        this.onStateActivated();
        for (String attr : this.attributeContractList) {
            summaryList.add(new SummaryInfo("attribute", attr, this));
        }
        if (this.attributeContractList.size() == 0) {
            summaryList.add(new SummaryInfo("none", "", this));
        }
    }

    public boolean isAttrQueryEnabled() {
        return this.selectedAttributeSource.equals(ADDITIONAL_VALUES);
    }

    public List<String> getAttributeContractList() {
        return this.attributeContractList;
    }

    public void setAttributeContractList(List<String> attributeContractList) {
        this.attributeContractList = attributeContractList;
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection tempConnection = (IdpConnection)dataToDisk;
        tempConnection.getUserProvisioning().setDoAttributeQuery(this.selectedAttributeSource.equals(ADDITIONAL_VALUES));
        return true;
    }

    @Override
    public void reset() {
        this.selectedAttributeSource = ASSERTION_ONLY;
    }

    public boolean isAttributeQuerySelected() {
        IdpConnectionConfigTasklet idpConnConfigTasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return idpConnConfigTasklet.isAttributeQuerySelected();
    }

    public String getDisabled() {
        return "disabled";
    }
}

