/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class UserInformationState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private List<AdministrativeUser> users;
    private Boolean newUser = false;
    private String userName;
    private String salt;
    private String hash;
    private String phoneNumber;
    private String emailAddress;
    private String department;
    private String description;
    private Boolean adminManager;
    private Boolean admin;
    private Boolean cryptoManager;
    private Boolean expressionManager;
    private Boolean dataCollectionAdmin;
    private Boolean auditor;
    private Boolean active;
    private Boolean changeRequired;

    public UserInformationState(Tasklet value) {
        super(value);
        this.setMenuName("User Information");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            AdministrativeUser user = (AdministrativeUser)dataFromDisk;
            this.userName = user.getUserName();
            this.salt = user.getSalt();
            this.hash = user.getHash();
            this.phoneNumber = user.getPhoneNumber();
            this.emailAddress = user.getEmailAddress();
            this.department = user.getDepartment();
            this.description = user.getDescription();
            this.adminManager = user.getAdminManager();
            this.admin = user.getAdmin();
            this.cryptoManager = user.getCryptoManager();
            this.dataCollectionAdmin = user.getDataCollectionAdmin();
            this.auditor = user.getAuditor();
            this.active = user.isActive();
            this.changeRequired = user.getChangeRequired();
            this.expressionManager = user.isExpressionAdmin();
        } else {
            this.adminManager = Boolean.FALSE;
            this.admin = Boolean.FALSE;
            this.cryptoManager = Boolean.FALSE;
            this.dataCollectionAdmin = Boolean.FALSE;
            this.auditor = Boolean.FALSE;
            this.active = Boolean.TRUE;
            this.changeRequired = Boolean.TRUE;
            this.expressionManager = Boolean.FALSE;
        }
    }

    public void getUserChanges(AdministrativeUser adminUser) {
        adminUser.setUserName(this.userName);
        adminUser.setSalt(this.salt);
        adminUser.setHash(this.hash);
        adminUser.setPhoneNumber(this.phoneNumber);
        adminUser.setEmailAddress(this.emailAddress);
        adminUser.setDepartment(this.department);
        adminUser.setDescription(this.description);
        adminUser.setAdminManager(this.adminManager.booleanValue());
        adminUser.setAdmin(this.admin.booleanValue());
        adminUser.setCryptoManager(this.cryptoManager.booleanValue());
        adminUser.setDataCollectionAdmin(this.dataCollectionAdmin.booleanValue());
        adminUser.setExpressionAdmin(this.expressionManager.booleanValue());
        adminUser.setAuditor(this.auditor.booleanValue());
        adminUser.setActive(this.active.booleanValue());
        adminUser.setChangeRequired(this.changeRequired.booleanValue());
        adminUser.setLocalAccount(true);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        EmailValidator emailValidator;
        if (StringUtils.isBlank((String)this.userName)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Username_required"), ValidationConstraint.REQUIRED);
        } else if (this.newUser.booleanValue()) {
            for (AdministrativeUser tempUser : this.users) {
                if (!tempUser.getUserName().equalsIgnoreCase(this.userName)) continue;
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Unique_username_required"), ValidationConstraint.REQUIRED);
                break;
            }
        }
        if (this.isEmailAddressMandatory() && StringUtils.isBlank((String)this.emailAddress)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Email_address_required"), ValidationConstraint.REQUIRED);
        }
        if (!StringUtils.isBlank((String)this.emailAddress) && !(emailValidator = EmailValidator.getInstance()).isValid(this.emailAddress)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Invalid_email_format"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean isEmailAddressMandatory() {
        return MgmtFactory.getNotificationMgr().getNotificationSettings().isEnableAccountChangesNotification();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Username"), this.userName, this));
        summaryList.add(new SummaryInfo(this.getMessage("Phone_number"), this.phoneNumber, this));
        summaryList.add(new SummaryInfo(this.getMessage("Email_address"), this.emailAddress, this));
        summaryList.add(new SummaryInfo(this.getMessage("Department"), this.department, this));
        summaryList.add(new SummaryInfo(this.getMessage("Description"), this.description, this));
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName.trim();
    }

    public Boolean getNewUser() {
        return this.newUser;
    }

    public void setNewUser(Boolean newUser) {
        this.newUser = newUser;
    }

    public List<AdministrativeUser> getUsers() {
        return this.users;
    }

    public void setUsers(List<AdministrativeUser> users) {
        this.users = users;
    }
}

