/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.common.util.ognl.ExpressionCalculator;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.GenericPopUpDataItem;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.ProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.ExpressDeprovisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressDeprovisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.ProvisioningProcessorManager;
import org.sourceid.websso.profiles.sp.provisioning.commands.Provision;
import org.sourceid.websso.profiles.sp.provisioning.commands.ProvisionSqlServer;
import org.sourceid.websso.profiles.sp.provisioning.commands.TestDeprovision;
import org.sourceid.websso.profiles.sp.provisioning.commands.TestDeprovisionJdbc;
import org.sourceid.websso.profiles.sp.provisioning.commands.TestProvision;
import org.sourceid.websso.profiles.sp.provisioning.commands.TestProvisionSqlServer;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;
import org.sourceid.websso.profiles.sp.provisioning.handlers.JdbcDataHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.NullableColumnAssignmentHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.SqlServerDataTypeCoersionHandler;
import org.sourceid.websso.profiles.sp.provisioning.invokers.JdbcDeprovisioningInvoker;
import org.sourceid.websso.profiles.sp.provisioning.invokers.SqlServerProvisioningInvoker;

public class UserProvisioningAdapterContractMappingState
extends MappingState {
    private static final long serialVersionUID = 1L;
    private static final String BLANK = "<blank>";
    private boolean displayTestScreen;
    private List<ResultInfo> testDataList = new ArrayList<ResultInfo>();
    protected String testInsertStatus = new String();
    private Map<String, List<RollbackItem>> rollbackDataListCache = new HashMap<String, List<RollbackItem>>();
    private String targetColumnHeaderName;
    private static final String ERROR_DURING_EXPRESSION_EVAL = "Error during expression evaluation: ";

    public UserProvisioningAdapterContractMappingState(Tasklet value) {
        this(value, "userProvisioningAdapterContractMapping", "Target Column");
    }

    public UserProvisioningAdapterContractMappingState(Tasklet value, String name) {
        this(value, name, "Target Attribute");
    }

    public UserProvisioningAdapterContractMappingState(Tasklet value, String name, String targetColumnHeaderName) {
        super(value, name);
        this.setMenuName("Attribute Fulfillment");
        this.targetColumnHeaderName = targetColumnHeaderName;
        this.model.setTargetName(targetColumnHeaderName);
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        this.attributeMapping = connection.getUserProvisioning();
        this.model = new SAML2MappingModel(this.targetColumnHeaderName, this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection connection = (IdpConnection)dataToDisk;
        UserProvisioning outmap = connection.getUserProvisioning();
        outmap.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        return true;
    }

    @Override
    public void onStateActivated() {
        UserProvisioningTasklet t;
        this.resetTargetsOnChange();
        if (this.shutoffTestPage()) {
            this.displayTestScreen = false;
        }
        this.testInsertStatus = "";
        if (!this.isViewOnly() && !(t = this.getParent(UserProvisioningTasklet.class)).isTableSqlMethod()) {
            this.setNoteKey("UserProvisioningTasklet_UserProvisioningStoredProcParamMappingState");
        }
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        t = this.findParent(UserProvisioningTasklet.class);
        t.addStandardSourcesToPropertySelectionSources(this.sources);
        this.sources.addTextSource("Text");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        if (this.isJdbcProvisioning()) {
            this.testDataList = this.getAllColumnsWithMetadata();
            if (this.tableHasSystemManagedColumns(this.testDataList)) {
                this.sources.addSystemManagedSource("System Managed");
            }
        }
    }

    protected void resetTargetsOnChange() {
        Collection targets = this.getTarget();
        if (!targets.isEmpty() && !this.model.getTargets().containsAll(targets)) {
            this.model = new SAML2MappingModel(this.targetColumnHeaderName, this.attributeMapping, this.getCurrentUser());
        }
    }

    @Override
    public void reset() {
        this.model = new SAML2MappingModel(this.getCurrentUser());
        this.model.setTargetName(this.targetColumnHeaderName);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly()) {
            boolean useJdbcProvisioningChecking = this.isJdbcProvisioning();
            this.model.setUserProvisioningModel(useJdbcProvisioningChecking);
            this.sources.setAllowBlankTextValues(useJdbcProvisioningChecking);
            super.appendErrors(delegate, component, fastFail);
            if (useJdbcProvisioningChecking) {
                ArrayList<ResultInfo> listToTest = new ArrayList<ResultInfo>();
                List<ResultInfo> allColumnsWithMetadata = this.getAllColumnsWithMetadata();
                Map mapping = this.model.getMapping().getAttributeMapping();
                ArrayList<String> errors = new ArrayList<String>();
                block0: for (ResultInfo r : allColumnsWithMetadata) {
                    SqlServerDataTypeCoersionHandler handler = new SqlServerDataTypeCoersionHandler(null, JdbcExpressProvisioningProcessor.OPERATION.INSERT, true);
                    for (Map.Entry e : mapping.entrySet()) {
                        AttrMappingValue v = (AttrMappingValue)((List)e.getValue()).get(0);
                        if (!((String)e.getKey()).equals(r.getColumnName())) continue;
                        if (v.getType() == SourceType.SYSTEM_MANAGED) {
                            if (r.isSystemManaged()) continue block0;
                            errors.add(this.getMessage("Invalid_system_managed_assignment", new Object[]{r.getColumnName()}));
                        } else if (v.getType() != SourceType.SYSTEM_MANAGED && r.isSystemManaged()) {
                            errors.add(this.getMessage("Invalid_source_for_system_managed_column", new Object[]{r.getColumnName()}));
                        }
                        if (v.getType() == SourceType.TEXT) {
                            if (r.getColumnName().equals(this.getUniqueId()) && StringUtils.isEmpty((String)v.getValue())) {
                                errors.add(this.getMessage("Unique_id_column_must_have_value", new Object[]{r.getColumnName()}));
                            }
                            ResultInfo info = new ResultInfo(r);
                            info.setValue(v.getValue());
                            listToTest.add(info);
                            continue block0;
                        }
                        handler.doesResultInfoHaveSupportedType(r, errors);
                    }
                }
                JdbcDataHandler chain = new NullableColumnAssignmentHandler().setNext((JdbcDataHandler)new SqlServerDataTypeCoersionHandler(null, JdbcExpressProvisioningProcessor.OPERATION.INSERT, true));
                chain.process(listToTest, errors);
                if (!errors.isEmpty()) {
                    for (String error : errors) {
                        delegate.setFormComponent(null);
                        delegate.record(error, ValidationConstraint.REQUIRED);
                    }
                }
            }
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return !this.model.isTestingExpression() && !this.displayTestScreen;
    }

    public List<String> getTarget() {
        ArrayList<String> target = new ArrayList<String>();
        AttributeSourceApi t = this.findParent(AttributeSourceApi.class);
        List<String> selectedAttrs = t.getSelectedAttributes();
        if (!this.isViewOnly() && selectedAttrs != null && !selectedAttrs.isEmpty()) {
            target.addAll(selectedAttrs);
        } else if (this.attributeMapping != null) {
            target.addAll(this.attributeMapping.getAttributeMapping().keySet());
        }
        return target;
    }

    public IPropertySelectionModel getAttrQueryAttrValues() {
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        return t.getAttrQueryAttrValues();
    }

    public boolean showNullableColumn() {
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        return t.isTableSqlMethod();
    }

    public boolean isTableSqlMethod() {
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        return t.isTableSqlMethod();
    }

    public void test() {
        AttributeMap rawUserProvisioningAttrs = new AttributeMap();
        HashMap attributeMap = new HashMap();
        for (ResultInfo info : this.testDataList) {
            String frontEndValue = info.getValue();
            String columnName = info.getColumnName();
            ArrayList<AttrMappingValue> attrMappingValueList = new ArrayList<AttrMappingValue>();
            AttrMappingValue v = null;
            if (info.isDatetimeColumn()) {
                if (!StringUtils.isEmpty((String)frontEndValue)) {
                    if (!this.evaluateOgnlDate(frontEndValue)) {
                        this.setErrorStatus();
                        String error = "The value for '" + info.getColumnName() + "' cannot be translated into a date.";
                        this.delegate.setFormComponent(null);
                        this.delegate.record(error, ValidationConstraint.REQUIRED);
                        return;
                    }
                    v = new AttrMappingValue(SourceType.EXPRESSION, frontEndValue);
                } else {
                    v = new AttrMappingValue(SourceType.EXPRESSION, "null");
                }
            } else {
                if (info.getColumnName().equals(this.getUniqueId()) && StringUtils.isEmpty((String)frontEndValue)) {
                    this.delegate.setFormComponent(null);
                    this.delegate.record(this.getMessage("Unique_id_column_must_have_value", new Object[]{info.getColumnName()}), ValidationConstraint.REQUIRED);
                    return;
                }
                v = new AttrMappingValue(SourceType.TEXT, frontEndValue);
            }
            attrMappingValueList.add(v);
            attributeMap.put(columnName, attrMappingValueList);
            rawUserProvisioningAttrs.put(columnName, frontEndValue);
        }
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        UserProvisioning userProvisioning = new UserProvisioning();
        IdpConnection idpConnection = new IdpConnection();
        idpConnection.setUserProvisioning(userProvisioning);
        t.save(idpConnection);
        userProvisioning.setAttributeMap2(attributeMap);
        JdbcDataSource jdbc = this.getSelectedDataSource();
        try {
            ProvisioningProcessorManager manager = ProvisioningProcessorManager.getInstance();
            AttributeMap evaledUserProvisioningAttrs = ProvisioningProcessor.doTranslation((AttributeMapping)userProvisioning, (AttributeMap)rawUserProvisioningAttrs);
            ExpressProvisioningProcessor expressProvisioningProcessor = manager.getProvisioningProcessor((DataSource)jdbc, userProvisioning, evaledUserProvisioningAttrs, null);
            SqlServerProvisioningInvoker invoker = new SqlServerProvisioningInvoker((Provision)new ProvisionSqlServer(expressProvisioningProcessor), (TestProvision)new TestProvisionSqlServer(expressProvisioningProcessor));
            List columns = invoker.testInsert();
            if (this.isTableSqlMethod()) {
                JdbcDeprovisioningInvoker deprovInvoker = null;
                ResultInfo uniqueIdColumn = this.prepForDeprov(this.testDataList);
                ExpressDeprovisioningProcessor expressDeprovisioningProcessor = manager.getDeprovisioningProcessor(jdbc, this.getSchemaName(), this.getTableName(), uniqueIdColumn);
                if (expressDeprovisioningProcessor != null) {
                    deprovInvoker = new JdbcDeprovisioningInvoker((TestDeprovision)new TestDeprovisionJdbc((JdbcExpressDeprovisioningProcessor)expressDeprovisioningProcessor));
                }
                this.processReturnColumns(columns, this.testDataList);
                if (deprovInvoker != null) {
                    this.addToRollbackDataList(this.testDataList, deprovInvoker);
                }
                this.testInsertStatus = "The insert into '" + this.getTableName() + "' succeeded.";
            } else {
                this.testInsertStatus = "The call to '" + this.getTableName() + "' succeeded.";
            }
            this.testDataList = this.getAllColumnsWithMetadata();
        }
        catch (SaaSProvisioningException spe) {
            this.setErrorStatus();
            List errors = spe.getMessages();
            for (String error : errors) {
                this.delegate.setFormComponent(null);
                this.delegate.record(error, ValidationConstraint.REQUIRED);
            }
        }
        catch (Exception e) {
            this.setErrorStatus();
            String cause = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "";
            this.delegate.setFormComponent(null);
            this.delegate.record(this.testInsertStatus + "  " + cause, ValidationConstraint.REQUIRED);
        }
    }

    private void setErrorStatus() {
        this.testInsertStatus = this.isTableSqlMethod() ? "There was a problem inserting into '" + this.getTableName() + "'." : "There was a problem calling '" + this.getTableName() + "'.";
    }

    private boolean tableHasSystemManagedColumns(List<ResultInfo> listToInsert) {
        for (ResultInfo info : listToInsert) {
            if (!info.isSystemManaged()) continue;
            return true;
        }
        return false;
    }

    private boolean shutoffTestPage() {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        return !expressionManager.isEvaluateExpressionsOn() && this.tableHasDatetimeColumns(this.getAllColumnsWithMetadata());
    }

    private boolean tableHasDatetimeColumns(List<ResultInfo> listToInsert) {
        for (ResultInfo info : listToInsert) {
            if (!info.isDatetimeColumn()) continue;
            return true;
        }
        return false;
    }

    public void rollbackAll() {
        ArrayList<RollbackItem> listToRemove = new ArrayList<RollbackItem>();
        for (RollbackItem item : this.getRollbackDataList()) {
            try {
                item.getJdbcDeprovisioningInvoker().testDelete();
                this.testInsertStatus = "";
                listToRemove.add(item);
            }
            catch (SaaSProvisioningException spe) {
                List errors = spe.getMessages();
                for (String error : errors) {
                    this.delegate.setFormComponent(null);
                    this.delegate.record(error, ValidationConstraint.REQUIRED);
                }
                this.testInsertStatus = "There was a problem deleting from '" + this.getTableName() + "'.";
                break;
            }
        }
        this.removeFromRollbackDataList(listToRemove);
    }

    private List<ResultInfo> getAllColumnsWithMetadata() {
        ArrayList<ResultInfo> freshResultInfoList = new ArrayList<ResultInfo>();
        UserProvisioningTasklet t = (UserProvisioningTasklet)this.getParent();
        List<ResultInfo> allColumnsWithMetadata = t.getAllColumnsWithMetadata();
        if (allColumnsWithMetadata != null) {
            for (ResultInfo info : allColumnsWithMetadata) {
                freshResultInfoList.add(new ResultInfo(info));
            }
        }
        return freshResultInfoList;
    }

    public List<String> getRollbackDisplayList() {
        ArrayList<String> displayList = new ArrayList<String>();
        for (RollbackItem item : this.getRollbackDataList()) {
            ArrayList<String> row = new ArrayList<String>();
            for (ResultInfo r : item.getRowValues()) {
                String v = r.getValue();
                row.add(!StringUtils.isEmpty((String)v) ? v : BLANK);
            }
            displayList.add(Util.listToCommaDelimString(row));
        }
        return displayList;
    }

    private List<RollbackItem> getRollbackDataList() {
        ArrayList rollbackDataList = this.rollbackDataListCache.get(this.getKey());
        return rollbackDataList != null ? rollbackDataList : new ArrayList();
    }

    private ResultInfo prepForDeprov(List<ResultInfo> listToAdjust) throws OgnlException {
        ResultInfo uniqueIdColumn = null;
        block5: for (ResultInfo r : listToAdjust) {
            switch (r.getDataType()) {
                case -7: {
                    BigInteger zero;
                    String value = r.getValue();
                    if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                        Boolean b = Boolean.parseBoolean(r.getValue());
                        r.setValue(b.toString());
                        continue block5;
                    }
                    if ("null".equalsIgnoreCase(value) || "".equals(value)) {
                        r.setValue("null");
                        continue block5;
                    }
                    BigInteger bigInt = new BigInteger(r.getValue());
                    r.setValue(String.valueOf(bigInt.compareTo(zero = new BigInteger("0")) != 0));
                    continue block5;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (!"".equals(r.getValue())) continue block5;
                    r.setValue("null");
                    continue block5;
                }
                case 93: {
                    if (StringUtils.isEmpty((String)r.getValue()) || "null".equalsIgnoreCase(r.getValue())) break;
                    Object parsedExpression = Ognl.parseExpression((String)r.getValue());
                    String result = (String)ExpressionCalculator.calculate((Object)parsedExpression, null, null);
                    r.setValue(result);
                }
            }
            if (!this.getUniqueId().equals(r.getColumnName())) continue;
            uniqueIdColumn = r;
        }
        return uniqueIdColumn;
    }

    private void addToRollbackDataList(List<ResultInfo> rollbackListToAdd, JdbcDeprovisioningInvoker deprovInvoker) {
        String key = this.getKey();
        List<RollbackItem> rollbackDataList = this.rollbackDataListCache.get(key);
        if (rollbackDataList == null) {
            rollbackDataList = new ArrayList<RollbackItem>();
        }
        rollbackDataList.add(new RollbackItem(rollbackListToAdd, deprovInvoker));
        this.rollbackDataListCache.put(key, rollbackDataList);
    }

    private void removeFromRollbackDataList(List<RollbackItem> listToRemove) {
        List<RollbackItem> lists = this.rollbackDataListCache.get(this.getKey());
        for (RollbackItem item : listToRemove) {
            lists.remove(item);
        }
    }

    private void processReturnColumns(List<String> columns, List<ResultInfo> testDataList) {
        if (!columns.isEmpty()) {
            for (String column : columns) {
                String[] tokens = column.split("-");
                if (tokens.length <= 1) continue;
                String ordinalPosition = tokens[0];
                String returnValue = tokens[1];
                ResultInfo info = testDataList.get(Integer.parseInt(ordinalPosition) - 1);
                info.setValue(returnValue);
            }
        }
    }

    private boolean evaluateOgnlDate(String expression) {
        Object result = this.wasTestSuccessful(expression);
        return result != null;
    }

    private Object wasTestSuccessful(String expression) {
        try {
            Object parsedExpression = Ognl.parseExpression((String)expression);
            OgnlHelper ognlHelper = new OgnlHelper();
            ognlHelper.searchForAllVariableNames(parsedExpression);
            Map<String, String> substitutionValues = this.getSources().getValidSubstituterValues();
            substitutionValues.remove("null");
            if (ognlHelper.containsInvalidSubstitutions(substitutionValues) != null) {
                return null;
            }
            HashMap<String, AttributeValue> testDataMap = new HashMap<String, AttributeValue>();
            Map<String, IComponent> components = this.getPageComponents();
            DataMap dataMapComponent = (DataMap)components.get("$DataMap");
            for (TestDataItem item : dataMapComponent.getTestDataList()) {
                testDataMap.put(item.getFieldName(), new AttributeValue(item.getTestValue()));
            }
            return ognlHelper.processOgnlExpression(parsedExpression, testDataMap, testDataMap);
        }
        catch (OgnlException e) {
            String msg = ERROR_DURING_EXPRESSION_EVAL + ExceptionUtil.toStringWithCauses((Throwable)e);
            this.log.debug((Object)msg);
            return null;
        }
    }

    private String getKey() {
        return this.getSelectedDataSourceName() + this.getSchemaName() + this.getTableName();
    }

    public String getSchemaName() {
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        return t.getSchemaName();
    }

    public String getTableName() {
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        return t.getTableName();
    }

    private String getSelectedDataSourceName() {
        return this.getSelectedDataSource().getJndiName();
    }

    private JdbcDataSource getSelectedDataSource() {
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        return (JdbcDataSource)t.getSelectedDataSource();
    }

    public List<String> getDataMapListOrder() {
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        if (t.isJdbcProvisioning()) {
            List<String> selectedAttrs = t.getSelectedAttributes();
            return selectedAttrs;
        }
        return null;
    }

    private String getUniqueId() {
        UserProvisioningTasklet tasklet = this.findParent(UserProvisioningTasklet.class);
        return tasklet.getSelectedColumn();
    }

    public List<String> getDatetimeColumns() {
        ArrayList<String> datetimeColumns = new ArrayList<String>();
        UserProvisioningTasklet t = (UserProvisioningTasklet)this.getParent();
        List<ResultInfo> allColumnsWithMetadata = t.getAllColumnsWithMetadata();
        if (allColumnsWithMetadata != null) {
            for (ResultInfo info : allColumnsWithMetadata) {
                if (!info.isDatetimeColumn()) continue;
                datetimeColumns.add(info.getColumnName());
            }
        }
        return datetimeColumns;
    }

    public String getTestLinkText() {
        UserProvisioningTasklet t = this.getParent(UserProvisioningTasklet.class);
        return t.isTableSqlMethod() ? "Test insert into '" + this.getTableName() + "'" : "Test call to '" + this.getTableName() + "'";
    }

    public String getTestButtonText() {
        UserProvisioningTasklet t = this.getParent(UserProvisioningTasklet.class);
        return t.isTableSqlMethod() ? "Test Insert" : "Test Stored Procedure Call";
    }

    public boolean isJdbcProvisioning() {
        UserProvisioningTasklet t = (UserProvisioningTasklet)this.getParent();
        return t.isJdbcProvisioning();
    }

    public String getTestInsertStatus() {
        return this.testInsertStatus;
    }

    public void setTestInsertStatus(String testInsertStatus) {
        this.testInsertStatus = testInsertStatus;
    }

    public boolean getDisplayTestScreen() {
        return this.displayTestScreen;
    }

    public void setDisplayTestScreen(boolean displayTestScreen) {
        this.displayTestScreen = displayTestScreen;
    }

    public List<ResultInfo> getTestDataList() {
        return this.testDataList;
    }

    public void setTestDataList(List<ResultInfo> testDataList) {
        this.testDataList = testDataList;
    }

    public boolean showTestLink() {
        return !this.displayTestScreen && this.isJdbcProvisioning() && !this.model.isTestingExpression() && !this.shutoffTestPage();
    }

    public String getTestTargetName() {
        return this.model.getTargetName();
    }

    public List<GenericPopUpDataItem> getDatetimeOgnlExampleList() {
        ArrayList<GenericPopUpDataItem> examples = new ArrayList<GenericPopUpDataItem>();
        try {
            int numberOfExamples = Integer.parseInt(this.getMessage("Datetime_examples_total"));
            for (int i = 1; i <= numberOfExamples; ++i) {
                String example = this.getMessage("Datetime_example_" + i);
                if (StringUtils.isEmpty((String)example)) continue;
                GenericPopUpDataItem item = new GenericPopUpDataItem();
                item.setColA(example);
                String remarks = this.getMessage("Datetime_remarks_" + i);
                if (!StringUtils.isEmpty((String)remarks) && !remarks.contains("_")) {
                    item.setColB(remarks);
                }
                examples.add(item);
            }
        }
        catch (NumberFormatException nfe) {
            this.log.error((Object)("Cannot find the correct integer value for: " + this.getMessageSimpleName() + "_Datetime_examples_total"));
        }
        return examples;
    }

    public String getDatetimeSynopsis() {
        return StringUtils.defaultString((String)this.getMessage("Datetime_synopsis"));
    }

    public String getTargetColumnHeaderName() {
        return this.targetColumnHeaderName;
    }

    private static class RollbackItem
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private List<ResultInfo> rowValues = new ArrayList<ResultInfo>();
        private transient JdbcDeprovisioningInvoker jdbcDeprovisioningInvoker;

        public RollbackItem(List<ResultInfo> rowValues, JdbcDeprovisioningInvoker jdbcDeprovisioningInvoker) {
            this.rowValues = rowValues;
            this.jdbcDeprovisioningInvoker = jdbcDeprovisioningInvoker;
        }

        public List<ResultInfo> getRowValues() {
            return this.rowValues;
        }

        public JdbcDeprovisioningInvoker getJdbcDeprovisioningInvoker() {
            return this.jdbcDeprovisioningInvoker;
        }
    }
}

