/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.IdpConnection;

public class UserProvisioningState
extends SingleTaskletState {
    private static final long serialVersionUID = 20050515L;
    private IdpConnection idpConnection;
    private Object populateAllStatesData;
    private static final String NOT_CONFIGURED = "Not Configured";

    public UserProvisioningState(Tasklet value) {
        super(value);
        this.setMenuName(this.getStateDescription());
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.idpConnection = (IdpConnection)dataFromDisk;
        this.populateTasklet();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(UserProvisioningTasklet.class);
            tasklet.configureTasklet();
            if (this.idpConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.idpConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            ConnectionTasklet connTasklet = this.getParent(ConnectionTasklet.class);
            if (!connTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    public boolean isLdapProvisioning() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet != null) {
            return tasklet.isLdapProvisioning();
        }
        return false;
    }

    public boolean isShowEventTrigger() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet != null) {
            return tasklet.isTableSqlMethod();
        }
        return true;
    }

    public String getEventTrigger() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getEventTrigger();
    }

    public String getUserRepository() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getUserRepository();
    }

    public String getUserAttributes() {
        IdpConnectionConfigTasklet tasklet = this.getParent(IdpConnectionConfigTasklet.class);
        return Util.listToCommaDelimString(tasklet.getAllAttrNamesSorted());
    }

    public String getErrorHandling() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getErrorHandling();
    }

    public String getAttributeQueryStatus() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet == null) {
            return NOT_CONFIGURED;
        }
        return tasklet.getAttributeQueryStatus();
    }

    public boolean isUsingStoredProcedure() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet == null) {
            return false;
        }
        return tasklet.isUsingStoredProcedure();
    }

    public String getSelectedSqlMethodForDisplay() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet != null) {
            return tasklet.getSelectedSqlMethodForDisplay();
        }
        return NOT_CONFIGURED;
    }

    public String getStoredProcedureName() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet != null) {
            return tasklet.getStoredProcedureName();
        }
        return NOT_CONFIGURED;
    }

    public boolean isSaml20() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        if (tasklet == null) {
            return false;
        }
        return tasklet.isConnectionProtocol20();
    }

    public boolean isJitProvisioning() {
        return true;
    }

    public boolean isAttrQueryEnabled() {
        UserProvisioningTasklet tasklet = this.getTaskletToEdit(UserProvisioningTasklet.class);
        return tasklet != null && tasklet.isAttrQueryEnabled();
    }

    public String getStateDescription() {
        return "JIT Provisioning";
    }

    public String getStateButtonDescription() {
        return "Configure " + this.getStateDescription();
    }
}

