/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import com.pingidentity.fsm.tasklet.impl.UserProvisioningTasklet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.AttributeSourceFactory;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class UserRepositoryState
extends SelectDataSourceState {
    protected static final String MENU_NAME = "Repository";
    private static final long serialVersionUID = 20050515L;
    List<String> allAttributes;

    public UserRepositoryState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName(MENU_NAME);
    }

    @Override
    protected List<DataSource> loadDataSources() {
        DataSourceManager dataMgr = MgmtFactory.getDataSourceManager();
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        if (this.isInboundProvisioningTasklet()) {
            for (LdapDataSource ldapDS : dataMgr.getLdapDataSources()) {
                if (!ldapDS.isActiveDirectoryType()) continue;
                dataSources.add((DataSource)ldapDS);
            }
        } else {
            dataSources.addAll(dataMgr.getLdapDataSources());
            dataSources.addAll(UserRepositoryState.cullJdbcDataSources(dataMgr.getJdbcDataSources()));
        }
        return dataSources;
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        AttributeSource attributeSource = this.isInboundProvisioningTasklet() ? connection.getInboundProvisioning().getWriteUsersAttributeMapping().getAttributeSource() : connection.getUserProvisioning().getAttributeSource();
        if (attributeSource != null) {
            this.setAttrSourceDesc(attributeSource.getDescription());
            this.selectedDataSource = attributeSource.getDataSource();
            this.selectedDataSourceId = this.selectedDataSource.getId();
            if (this.selectedDataSource instanceof LdapDataSource) {
                this.setDataSourceType(DataSource.DSType.LDAP);
            } else if (this.selectedDataSource instanceof JdbcDataSource) {
                this.setDataSourceType(DataSource.DSType.JDBC);
            }
        }
        this.getParent().reconfigureTransitions(this);
        super.populate();
    }

    private void checkDataSources() {
        AttributeSourceApi t = this.getParent(AttributeSourceApi.class);
        if (this.selectedDataSource != null && !t.isDataStoreAvailable(this.selectedDataSource)) {
            if (this.isInboundProvisioningTasklet()) {
                ((InboundProvisioningTasklet)t).setStatesToVOMode(this.selectedDataSource);
            } else {
                ((UserProvisioningTasklet)t).setStatesToVOMode(this.selectedDataSource);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(MENU_NAME, this.getDataSourceDesc(), this));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedDataSource == null) {
            delegate.record(this.getMessage("Data_store_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection tempConnection = (IdpConnection)dataToDisk;
        AttributeSource source = AttributeSourceFactory.getAttributeSource((DataSource)this.selectedDataSource, (String)this.getAttrSourceDesc());
        tempConnection.getUserProvisioning().setAttributeSource(source);
        return true;
    }

    public List<String> getAllAttributes() {
        if (this.allAttributes == null && !this.isViewOnly()) {
            DataSource ds = this.getSelectedDataSource();
            if (ds instanceof LdapDataSource) {
                this.allAttributes = ((LdapDataSource)ds).getLDAPAttributeNameList();
            } else if (!(ds instanceof JdbcDataSource)) {
                this.allAttributes = new ArrayList<String>();
            }
        }
        return this.allAttributes;
    }

    private static Collection<JdbcDataSource> cullJdbcDataSources(Collection<JdbcDataSource> jdbcDataSources) {
        ArrayList<JdbcDataSource> allowedJdbcDataSources = new ArrayList<JdbcDataSource>();
        for (JdbcDataSource jdbc : jdbcDataSources) {
            if (!jdbc.hasExpressProvSupport()) continue;
            allowedJdbcDataSources.add(jdbc);
        }
        return allowedJdbcDataSources;
    }

    private boolean isInboundProvisioningTasklet() {
        Tasklet tasklet = this.getParent();
        return tasklet instanceof InboundProvisioningTasklet;
    }
}

