/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.VirtualServerIdsReferencer;

public class VirtualServerIdMappingState
extends TaskletState {
    private static final long serialVersionUID = 20050123L;
    private final CheckboxModel checkboxModel = new CheckboxModel();
    private boolean restrictVirtualServerIds;

    public VirtualServerIdMappingState(IWizard owner) {
        super(owner);
        this.setMenuName("Virtual Server IDs");
    }

    @Override
    public void onStateActivated() {
        this.loadCheckboxModel(null);
    }

    @Override
    public void populate(Object dataFromDisk) {
        VirtualServerIdsReferencer ref = (VirtualServerIdsReferencer)dataFromDisk;
        this.setRestrictVirtualServerIds(ref.isRestrictVirtualServerIds());
        this.loadCheckboxModel(ref.getRestrictedVirtualServerIds());
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
    }

    @Override
    public void onResumeDraft() {
        super.onResumeDraft();
    }

    @Override
    public boolean save(Object dataToDisk) {
        VirtualServerIdsReferencer adapterMapping = (VirtualServerIdsReferencer)dataToDisk;
        adapterMapping.setRestrictVirtualServerIds(this.isRestrictVirtualServerIds());
        adapterMapping.setRestrictedVirtualServerIds(this.getRestrictedVirtualServerIds());
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        List<String> restrictedIds = this.getRestrictedVirtualServerIds();
        if (restrictedIds.isEmpty()) {
            summaryList.add(new SummaryInfo("Restricted Virtual Server ID", "(none)", this));
        } else {
            for (String restrictedVirtualServerId : restrictedIds) {
                summaryList.add(new SummaryInfo("Restricted Virtual Server ID", restrictedVirtualServerId, this));
            }
        }
    }

    public CheckboxModel getCheckboxModel() {
        return this.checkboxModel;
    }

    private void loadCheckboxModel(List<String> restrictedVirtualServerIds) {
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        if (connectionTasklet != null) {
            ArrayList<CheckboxItem> list = new ArrayList<CheckboxItem>();
            if (this.checkboxModel.getCheckboxItems() != null) {
                list.addAll(this.checkboxModel.getCheckboxItems());
            }
            if (connectionTasklet.getVirtualEntityIds() != null) {
                for (String virtualEntityId : connectionTasklet.getVirtualEntityIds()) {
                    boolean existingVirtualEntityId = list.stream().anyMatch(vsid -> vsid.getName().equals(virtualEntityId));
                    if (existingVirtualEntityId) continue;
                    CheckboxItem item = new CheckboxItem(virtualEntityId, false);
                    if (restrictedVirtualServerIds != null && restrictedVirtualServerIds.contains(virtualEntityId)) {
                        item.setChecked(true);
                    }
                    list.add(item);
                }
            }
            this.checkboxModel.setCheckboxItems(list);
        }
    }

    public boolean isRestrictVirtualServerIds() {
        return this.restrictVirtualServerIds;
    }

    public List<String> getRestrictedVirtualServerIds() {
        List<String> virtualServerIds = new ArrayList<String>();
        if (this.isRestrictVirtualServerIds() && this.checkboxModel != null) {
            virtualServerIds = this.checkboxModel.getSelectedNames();
        }
        return virtualServerIds;
    }

    public void setRestrictVirtualServerIds(boolean restrictVirtualServerIds) {
        this.restrictVirtualServerIds = restrictVirtualServerIds;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        boolean anyMatchFound;
        if (this.isRestrictVirtualServerIds() && !(anyMatchFound = this.getCheckboxModel().getCheckboxItems().stream().anyMatch(CheckboxItem::getChecked))) {
            delegate.record(this.getMessage("restricted_virtual_entity_ids_required"), ValidationConstraint.REQUIRED);
        }
    }
}

