/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsFedNameIdentifierMappingType;
import java.util.ArrayList;
import org.sourceid.saml20.domain.SpConnection;

public class WsFedIdentityMappingState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    public static WsFedNameIdentifierMappingType emailAddrType = WsFedNameIdentifierMappingType.EMAIL_ADDR;
    public static WsFedNameIdentifierMappingType principalNameType = WsFedNameIdentifierMappingType.PRINCIPAL_NAME;
    public static WsFedNameIdentifierMappingType commonNameType = WsFedNameIdentifierMappingType.COMMON_NAME;
    private WsFedNameIdentifierMappingType nameIdentifierMappingType = WsFedNameIdentifierMappingType.EMAIL_ADDR;

    public WsFedIdentityMappingState(Tasklet parent) {
        super(parent);
        this.setMenuName("Identity Mapping");
    }

    @Override
    public void populate(Object dataFromDisk) {
        SpConnection connection = (SpConnection)dataFromDisk;
        String nameIdFormat = connection.getNameIdFormat();
        this.nameIdentifierMappingType = WsFedNameIdentifierMappingType.fromFormatUri(nameIdFormat);
    }

    @Override
    public boolean save(Object dataToDisk) {
        SpConnection spConnection = (SpConnection)dataToDisk;
        WsFedNameIdentifierMappingType nameIdentifierMappingType = this.getNameIdentifierMappingType();
        String nameIdFormat = nameIdentifierMappingType.getNameIdFormatUri();
        spConnection.setNameIdFormat(nameIdFormat);
        return true;
    }

    @Override
    public void reset() {
        this.nameIdentifierMappingType = WsFedNameIdentifierMappingType.EMAIL_ADDR;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String mappingType;
        switch (this.nameIdentifierMappingType) {
            case EMAIL_ADDR: {
                mappingType = "Email Address";
                break;
            }
            case PRINCIPAL_NAME: {
                mappingType = "User Principal Name";
                break;
            }
            case COMMON_NAME: {
                mappingType = "Common Name";
                break;
            }
            default: {
                mappingType = "Unknown";
            }
        }
        summaryList.add(new SummaryInfo(this.getMessage("Name_Identifier"), mappingType, this));
    }

    public WsFedNameIdentifierMappingType getNameIdentifierMappingType() {
        return this.nameIdentifierMappingType;
    }

    public void setNameIdentifierMappingType(WsFedNameIdentifierMappingType nameIdentifierMappingType) {
        this.nameIdentifierMappingType = nameIdentifierMappingType;
    }
}

