/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenProcessorMappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class WsTrustAttrContractFulfillmentState
extends MappingState {
    private static final long serialVersionUID = 2L;

    public WsTrustAttrContractFulfillmentState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Contract Fulfillment");
        this.model.setTargetName("Attribute Contract");
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenPluginAttributeMapping targetAttrMapping = (TokenPluginAttributeMapping)dataFromDisk;
        this.model = new SAML2MappingModel("Attribute Contract", targetAttrMapping.getAttributeMapping(), this.getCurrentUser());
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        WsTrustTokenProcessorMappingTasklet t = this.findParent(WsTrustTokenProcessorMappingTasklet.class);
        t.addStandardSourcesToPropertySelectionSources(this.sources);
        t.addExtendedPropertiesToSelectionSources(this.sources);
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenPluginAttributeMapping tokenPluginAttrMapping = (TokenPluginAttributeMapping)dataToDisk;
        AttributeMapping attrMapping = tokenPluginAttrMapping.getAttributeMapping();
        if (attrMapping == null) {
            attrMapping = new AttributeMapping();
            tokenPluginAttrMapping.setAttributeMapping(attrMapping);
        }
        AttributeMapping currentMapping = this.model.getMapping();
        attrMapping.setAttributeMap2(currentMapping.getAttributeMapping());
        return true;
    }

    public List<String> getTarget() {
        WsTrustTokenProcessorMappingTasklet t = this.findParent(WsTrustTokenProcessorMappingTasklet.class);
        return t.getTarget();
    }

    public IPropertySelectionModel getPluginValues() {
        PluginMappingApi parentTasklet = (PluginMappingApi)((Object)this.getParent());
        ConfigurablePluginInstance instance = parentTasklet.getSelectedPlugin();
        ArrayList<String> names = new ArrayList<String>();
        if (instance != null) {
            if (parentTasklet.isOverridePluginPopulated()) {
                names.addAll(parentTasklet.getPluginContract());
            } else {
                names.addAll(instance.getAttributeContract().getAllAttrNamesSorted());
            }
        }
        return new StringPairPropertySelectionModel(true, names.toArray(new String[0]));
    }

    public WsTrustRequestContract getRequestContract() {
        String selectedContract = this.getSelectedContract();
        WsTrustRequestContractManager requestContractManager = (WsTrustRequestContractManager)GlobalRegistry.getService(WsTrustRequestContractManager.class);
        WsTrustRequestContract contract = requestContractManager.findById(selectedContract);
        return contract;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return !this.model.isTestingExpression();
    }

    public boolean isAdditionalParamsFromRequest() {
        WsTrustTokenProcessorMappingTasklet t = this.findParent(WsTrustTokenProcessorMappingTasklet.class);
        return t.isAdditionalParamsFromRequest();
    }

    public String getSelectedContract() {
        WsTrustTokenProcessorMappingTasklet t = this.findParent(WsTrustTokenProcessorMappingTasklet.class);
        return t.getSelectedContract();
    }
}

