/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.WsTrustSpTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;

public class WsTrustAttributeContractState
extends CreateAttributeContractState
implements AttributeNamesApi {
    private static final long serialVersionUID = 2L;

    public WsTrustAttributeContractState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Contract");
        this.setAttributeNameFormatLabel("Attribute Namespace");
        this.contract = new WsTrustTokenAttributeContract();
    }

    @Override
    public void onStateActivated() {
        AttributeContract attributeContract = this.makeEmptyAttributeContract(false, false);
        attributeContract.setMutableAttributeNames(this.contract.getMutableAttributeNames());
        attributeContract.setMutableAttributesInfo(this.contract.getMutableAttributesInfo());
        this.contract = attributeContract;
    }

    @Override
    public void populate(Object dataFromDisk) {
        WsTrustFederatedWscSettings settings = (WsTrustFederatedWscSettings)dataFromDisk;
        this.setComponentState(null);
        AttributeContract localContract = this.makeEmptyAttributeContract(false, false);
        WsTrustTokenAttributeContract existingContract = settings.getAttributeContract();
        if (existingContract != null) {
            HashSet immutableAttributeNames = new HashSet(existingContract.getImmutableAttributeNames());
            localContract.setImmutableAttributeNames(immutableAttributeNames);
            HashSet attributeNames = new HashSet(existingContract.getMutableAttributeNames());
            localContract.setMutableAttributeNames(attributeNames);
            HashMap<String, String> mutableAttributeInfo = new HashMap<String, String>();
            for (String attributeName : attributeNames) {
                mutableAttributeInfo.put(attributeName, existingContract.getMutableAttributeNameFormat(attributeName));
            }
            localContract.setMutableAttributesInfo(mutableAttributeInfo);
        }
        this.setContract(localContract);
    }

    @Override
    public boolean populateAllStates(Object data) {
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        SpConnection conn = (SpConnection)dataToDisk;
        WsTrustFederatedWscSettings settings = conn.getWsTrustSettings();
        WsTrustTokenAttributeContract wsTrustAttributeContract = new WsTrustTokenAttributeContract();
        wsTrustAttributeContract.setImmutableAttributeNames(this.getContract().getImmutableAttributeNames());
        wsTrustAttributeContract.setMutableAttributeNames(new HashSet(this.getContract().getMutableAttributeNames()));
        wsTrustAttributeContract.setMutableAttributesInfo(new HashMap(this.getContract().getMutableAttributesInfo()));
        settings.setAttributeContract(wsTrustAttributeContract);
        return true;
    }

    @Override
    public StringPairPropertySelectionModel getAttributeNameFormatModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        if (this.isIncludeAttributeNameFormat().booleanValue()) {
            WsTrustSpTasklet wsTrustSpTasklet = this.findParent(WsTrustSpTasklet.class);
            String defaultTokenType = wsTrustSpTasklet.getSelectedDefaultTokenType();
            if (Saml20SecurityToken.TYPE.equals(defaultTokenType)) {
                model.add("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            } else if (Saml11SecurityToken.TYPE.equals(defaultTokenType) || Saml11O365SecurityToken.TYPE.equals(defaultTokenType)) {
                ConfigStore createResponseConfig = ConfigStoreFarm.getConfig(CreateResponse.class);
                String ns = createResponseConfig.getStringValue("ns", "ns:unspecified");
                model.add(ns, ns);
            }
            model.add("http://schemas.xmlsoap.org/claims", "http://schemas.xmlsoap.org/claims");
            ConfigStore customNameFormatConfigStore = ConfigStoreFarm.getConfig((String)"custom-name-formats");
            Map customAttributeNameFormats = customNameFormatConfigStore.getMapValue("sts-attribute-namespaces", Collections.EMPTY_MAP);
            for (Object key : customAttributeNameFormats.keySet()) {
                model.add((String)customAttributeNameFormats.get(key), key);
            }
        }
        return model;
    }

    @Override
    public void reset() {
        this.setComponentState(null);
        this.contract = this.makeEmptyAttributeContract(false, false);
    }

    @Override
    public Boolean isMaskValues() {
        return false;
    }

    @Override
    public Boolean isIncludeAttributeNameFormat() {
        WsTrustSpTasklet wsTrustSpTasklet = this.findParent(WsTrustSpTasklet.class);
        if (wsTrustSpTasklet == null) {
            return false;
        }
        String defaultTokenType = wsTrustSpTasklet.getSelectedDefaultTokenType();
        boolean isSaml20Token = Saml20SecurityToken.TYPE.equals(defaultTokenType);
        boolean isSaml11Token = Saml11SecurityToken.TYPE.equals(defaultTokenType);
        boolean isSaml11O365Token = Saml11O365SecurityToken.TYPE.equals(defaultTokenType);
        return isSaml20Token || isSaml11Token || isSaml11O365Token;
    }

    @Override
    public Boolean isIncludeSubjectNameFormat() {
        return false;
    }

    @Override
    public String getAttributeNameFormatLabel() {
        return "Attribute Namespace";
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.contract.getAllAttrNamesSorted();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.contract.getAllAttributeNames();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.contract.getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.contract.getSortedMutableAttributeNames();
    }

    @Override
    protected AttributeContract makeEmptyAttributeContract(boolean includePseudonym, boolean includeTransientId) {
        return new WsTrustTokenAttributeContract();
    }
}

