/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGeneratorMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;

public class WsTrustConfigLdapDirSearchState
extends ConfigLdapDirSearchState
implements Serializable {
    static final String NO_ATTRIBUTES_LIST = "<no attributes available>";
    static final StringPairPropertySelectionModel NO_ATTRIBUTES_MODEL = new StringPairPropertySelectionModel();
    private static final long serialVersionUID = 20050515L;
    public static final String SHOW_ALL = "none";

    public WsTrustConfigLdapDirSearchState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("LDAP Directory Search");
    }

    @Override
    protected Collection<String> getAvailableSubstitutionAttributes() {
        Tasklet parentTasklet = this.getParent();
        if (parentTasklet instanceof WsTrustTokenGeneratorMappingTasklet) {
            return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
        }
        return Collections.emptyList();
    }

    @Override
    public void onStateActivated() {
        AttributeSourceApi parentTasklet = (AttributeSourceApi)((Object)this.getParent());
        LdapDataSource temp = (LdapDataSource)parentTasklet.getSelectedDataSource();
        super.initDataSource(temp);
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenPluginAttributeMapping tokenPluginAttributeMapping = (TokenPluginAttributeMapping)dataFromDisk;
        AttributeMapping attrMapping = tokenPluginAttributeMapping.getAttributeMapping();
        AttributeSource source = attrMapping.getAttributeSource();
        this.dataSource = (LdapDataSource)source.getDataSource();
        this.baseDN = source.getParameter("search_base");
        this.selectedSearchScope = source.getParameter("search_scope");
        this.selectedAttributes = this.getSelectedAttributesList(tokenPluginAttributeMapping.getAttributeMapping(), source);
        this.populateMemberOf(source);
        this.populate();
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenPluginAttributeMapping mapping = (TokenPluginAttributeMapping)dataToDisk;
        AttributeSource source = mapping.getAttributeMapping().getAttributeSource();
        this.save(source);
        return true;
    }

    @Override
    public String getLinkText() {
        Tasklet tasklet = this.getParent();
        if (tasklet instanceof WsTrustTokenGeneratorMappingTasklet) {
            return "View Token Generator Contract";
        }
        return super.getLinkText();
    }
}

