/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;

public class WsTrustIdpProtocolSettingsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private WsTrustFederatedWspSettings wsTrustSettings;
    private static String DO_NOT_ISSUE_LOCAL_TOKEN = "Do_not_issue_local_token";
    private static String ISSUE_LOCAL_TOKEN = "Issue_local_token";
    private String requestProcessingOption = DO_NOT_ISSUE_LOCAL_TOKEN;
    private boolean decryptAssertion;

    public WsTrustIdpProtocolSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Protocol Settings");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.wsTrustSettings = (WsTrustFederatedWspSettings)dataFromDisk;
        Collection mappings = this.wsTrustSettings.getAssertionToTokenMappingsMappings();
        this.requestProcessingOption = mappings == null || mappings.isEmpty() ? DO_NOT_ISSUE_LOCAL_TOKEN : ISSUE_LOCAL_TOKEN;
        this.decryptAssertion = this.wsTrustSettings.isDecryptAssertion();
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.wsTrustSettings = (WsTrustFederatedWspSettings)dataToDisk;
        this.wsTrustSettings.setDecryptAssertion(this.decryptAssertion);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Request_processing_options"), this.getMessage(this.getRequestProcessingOption()), this));
    }

    @Override
    public void reset() {
        this.requestProcessingOption = DO_NOT_ISSUE_LOCAL_TOKEN;
        this.decryptAssertion = false;
    }

    public StringPairPropertySelectionModel getRequestProcessingOptions() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        model.add(this.getMessage(DO_NOT_ISSUE_LOCAL_TOKEN), DO_NOT_ISSUE_LOCAL_TOKEN);
        model.add(this.getMessage(ISSUE_LOCAL_TOKEN), ISSUE_LOCAL_TOKEN);
        return model;
    }

    public String getRequestProcessingOption() {
        return this.requestProcessingOption;
    }

    public void setRequestProcessingOption(String requestProcessingOption) {
        this.requestProcessingOption = requestProcessingOption;
    }

    public boolean isIssueLocalToken() {
        return ISSUE_LOCAL_TOKEN.equals(this.requestProcessingOption);
    }

    public boolean isDecryptAssertion() {
        return false;
    }

    public void setDecryptAssertion(boolean decryptAssertion) {
        this.decryptAssertion = decryptAssertion;
    }
}

