/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustSpTokenCreationTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class WsTrustRequestContractSelectionState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private transient StringPairPropertySelectionModel contractList;
    private String selectedContract;
    private boolean additionalParamsFromRequest;

    public WsTrustRequestContractSelectionState(Tasklet value) {
        super(value);
        this.setMenuName("Request Contract");
    }

    @Override
    public void onStateActivated() {
        this.populate();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (!this.additionalParamsFromRequest) {
            this.selectedContract = null;
        }
        WsTrustSpTokenCreationTasklet t = this.findParent(WsTrustSpTokenCreationTasklet.class);
        t.configureTasklet();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.additionalParamsFromRequest && StringUtils.isEmpty((String)this.selectedContract)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Request_contract_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        WsTrustFederatedWscSettings settings = (WsTrustFederatedWscSettings)dataFromDisk;
        if (!StringUtils.isEmpty((String)settings.getRequestContractId())) {
            this.selectedContract = settings.getRequestContractId();
            this.additionalParamsFromRequest = true;
        }
        WsTrustSpTokenCreationTasklet t = this.findParent(WsTrustSpTokenCreationTasklet.class);
        t.configureTasklet();
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
        this.populate();
    }

    @Override
    public void prepareForTestDraft() {
        this.setTaskletToEditToNull();
    }

    private void populate() {
        this.contractList = new StringPairPropertySelectionModel(true);
        WsTrustRequestContractManager requestContractManager = (WsTrustRequestContractManager)GlobalRegistry.getService(WsTrustRequestContractManager.class);
        for (WsTrustRequestContract c : requestContractManager.findAll()) {
            this.contractList.add(c.getName(), c.getId());
        }
        this.contractList.sort();
    }

    @Override
    public boolean save(Object dataToDisk) {
        SpConnection conn = (SpConnection)dataToDisk;
        WsTrustFederatedWscSettings settings = conn.getWsTrustSettings();
        settings.setRequestContractId(this.selectedContract);
        if (!this.additionalParamsFromRequest) {
            settings.setAbortIfNotFulfilledFromRequest(false);
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Request_contract_desc"), new Boolean(this.additionalParamsFromRequest).toString(), this));
        if (this.additionalParamsFromRequest && !StringUtils.isEmpty((String)this.selectedContract)) {
            WsTrustRequestContractManager requestContractManager = (WsTrustRequestContractManager)GlobalRegistry.getService(WsTrustRequestContractManager.class);
            WsTrustRequestContract requestContract = requestContractManager.findById(this.selectedContract);
            summaryList.add(new SummaryInfo(this.getMessage("Request_contract_name_desc"), requestContract.getName(), this));
        }
    }

    public StringPairPropertySelectionModel getContractList() {
        return this.contractList;
    }

    public void setContractList(StringPairPropertySelectionModel contractList) {
        this.contractList = contractList;
    }

    public String getSelectedContract() {
        return this.selectedContract;
    }

    public void setSelectedContract(String selectedContract) {
        this.selectedContract = selectedContract;
    }

    public boolean isAdditionalParamsFromRequest() {
        return this.additionalParamsFromRequest;
    }

    public void setAdditionalParamsFromRequest(boolean additionalParamsFromRequest) {
        this.additionalParamsFromRequest = additionalParamsFromRequest;
    }
}

