/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.StsRequestParametersContractValidator;
import com.pingidentity.fsm.state.impl.WsTrustManageRequestContractsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class WsTrustRequestContractState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final WsTrustRequestContractManager requestContractManager = (WsTrustRequestContractManager)GlobalRegistry.getService(WsTrustRequestContractManager.class);
    private String requestContractName;
    private String requestContractId;
    private String requestElementToAdd;
    private String parameterNameToAdd;
    private int indexInEdit = -1;
    private String originalRequestElement;
    private String originalParameterName;
    private boolean newRequestContract = true;
    private List<RequestParameter> requestParameters = new ArrayList<RequestParameter>();

    public WsTrustRequestContractState(Tasklet value) {
        super(value);
        this.setMenuName(this.getMessage("Title"));
    }

    @Override
    public void populate(Object dataFromDisk) {
        WsTrustRequestContract requestContract = (WsTrustRequestContract)dataFromDisk;
        this.requestContractName = requestContract.getName();
        this.requestContractId = requestContract.getId();
        List allParameterNames = requestContract.getAllAttrNamesSorted();
        if (allParameterNames != null) {
            this.requestParameters = new ArrayList<RequestParameter>();
            for (String parameterName : allParameterNames) {
                RequestParameter requestParameter = new RequestParameter(parameterName, null);
                this.requestParameters.add(requestParameter);
            }
        }
        this.newRequestContract = false;
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustRequestContract requestContract = (WsTrustRequestContract)dataToDisk;
        this.fillInContract(requestContract);
        return true;
    }

    public void fillInContract(WsTrustRequestContract requestContract) {
        requestContract.setName(this.requestContractName);
        requestContract.setId(this.requestContractId);
        for (RequestParameter requestParameter : this.requestParameters) {
            if (requestParameter.isMarkedForDelete()) continue;
            requestContract.addMutableAttributeName(requestParameter.getParameterName());
        }
    }

    public void addParameter() {
        this.delegate.clearErrors();
        if (StringUtils.isEmpty((String)this.parameterNameToAdd)) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Parameter_name_required"), ValidationConstraint.REQUIRED);
        } else if (this.isParameterDefined(this.parameterNameToAdd, -1)) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Parameter_name_already_exists", new Object[]{this.parameterNameToAdd}), ValidationConstraint.REQUIRED);
        } else if (!StringUtils.isAlphanumeric((String)this.parameterNameToAdd)) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Parameter_name_invalid"), ValidationConstraint.REQUIRED);
        } else {
            RequestParameter requestParameterToAdd = new RequestParameter(this.parameterNameToAdd, this.requestElementToAdd);
            this.requestParameters.add(requestParameterToAdd);
            this.parameterNameToAdd = "";
            this.requestElementToAdd = "";
        }
    }

    public void editParameter(int index, String requestElement, String parameterName) {
        this.indexInEdit = index;
        this.originalRequestElement = requestElement;
        this.originalParameterName = parameterName;
        this.requestParameters.get(index).setEdit(true);
    }

    public void deleteParameter(int indexToDelete) {
        this.requestParameters.get(indexToDelete).setMarkedForDelete(true);
    }

    public void unDeleteParameter(int indexToDelete) {
        this.requestParameters.get(indexToDelete).setMarkedForDelete(false);
    }

    public void updateParameter() {
        this.delegate.clearErrors();
        RequestParameter requestParameter = this.requestParameters.get(this.indexInEdit);
        String newParameterName = requestParameter.getParameterName();
        if (StringUtils.isEmpty((String)newParameterName)) {
            this.delegate.record(this.getMessage("Parameter_name_required"), ValidationConstraint.REQUIRED);
        } else if (this.isParameterDefined(newParameterName, this.indexInEdit)) {
            this.delegate.record(this.getMessage("Parameter_name_already_exists", new Object[]{newParameterName}), ValidationConstraint.REQUIRED);
        } else if (!StringUtils.isAlphanumeric((String)newParameterName)) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Parameter_name_invalid"), ValidationConstraint.REQUIRED);
        }
        if (!this.delegate.getHasErrors()) {
            requestParameter.setEdit(false);
            this.indexInEdit = -1;
        }
    }

    public void cancelParameterEdit(int index) {
        RequestParameter requestParameter = this.requestParameters.get(index);
        requestParameter.setParameterName(this.originalParameterName);
        requestParameter.setRequestElement(this.originalRequestElement);
        requestParameter.setEdit(false);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        StsRequestParametersContractValidator validator = new StsRequestParametersContractValidator(this.requestContractId, this.requestContractName, this.getContractParameters(), requestContractManager, true);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
        if (this.isNewRequestContract()) {
            if (this.isRequestContractIdInUse(this.requestContractId)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Duplicate_contract_id"), ValidationConstraint.REQUIRED);
            }
            if (this.isRequestContractNameInUse(this.requestContractName)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Duplicate_contract_name"), ValidationConstraint.REQUIRED);
            }
        }
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Finish_editing_parameter"), ValidationConstraint.REQUIRED);
        }
    }

    private List<String> getContractParameters() {
        ArrayList<String> paramList = new ArrayList<String>();
        for (RequestParameter rp : this.requestParameters) {
            if (rp.isMarkedForDelete()) continue;
            paramList.add(rp.getParameterName());
        }
        return paramList;
    }

    private boolean isRequestContractIdInUse(String contractId) {
        WsTrustManageRequestContractsState manageRequestContractsState = this.findParentState(WsTrustManageRequestContractsState.class);
        return manageRequestContractsState.isRequestContractIdInUse(contractId);
    }

    private boolean isRequestContractNameInUse(String contractName) {
        WsTrustManageRequestContractsState manageRequestContractsState = this.findParentState(WsTrustManageRequestContractsState.class);
        return manageRequestContractsState.isRequestContractNameInUse(contractName);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Request_contract_name"), this.requestContractName, this));
        summaryList.add(new SummaryInfo(this.getMessage("Instance_id"), this.requestContractId, this));
        for (RequestParameter requestParameter : this.requestParameters) {
            summaryList.add(new SummaryInfo(this.getMessage("Parameter_name"), requestParameter.getParameterName(), this));
        }
    }

    private boolean isParameterDefined(String parameterName, int index) {
        for (int i = 0; i < this.requestParameters.size(); ++i) {
            RequestParameter requestParameter;
            if (i == index || !(requestParameter = this.requestParameters.get(i)).getParameterName().equals(parameterName)) continue;
            return true;
        }
        return false;
    }

    public String getRequestElementToAdd() {
        return this.requestElementToAdd;
    }

    public void setRequestElementToAdd(String requestElementToAdd) {
        this.requestElementToAdd = requestElementToAdd;
    }

    public List<RequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    public String getRequestContractName() {
        return this.requestContractName;
    }

    public void setRequestContractName(String requestContractName) {
        this.requestContractName = requestContractName;
    }

    public String getRequestContractId() {
        return this.requestContractId;
    }

    public void setRequestContractId(String requestContractId) {
        this.requestContractId = requestContractId;
    }

    public String getParameterNameToAdd() {
        return this.parameterNameToAdd;
    }

    public void setParameterNameToAdd(String parameterNameToAdd) {
        this.parameterNameToAdd = parameterNameToAdd;
    }

    public boolean isEditMode() {
        for (RequestParameter requestParameter : this.requestParameters) {
            if (!requestParameter.isEdit()) continue;
            return true;
        }
        return false;
    }

    public boolean isNewRequestContract() {
        return this.newRequestContract;
    }

    public void setNewRequestContract(boolean newRequestContract) {
        this.newRequestContract = newRequestContract;
    }

    public WsTrustRequestContract getCurrentContract() {
        WsTrustRequestContract contract = new WsTrustRequestContract();
        this.fillInContract(contract);
        return contract;
    }

    private class RequestParameter {
        private boolean edit = false;
        private boolean markedForDelete;
        private String parameterName;
        private String requestElement;

        public RequestParameter(String parameterName, String requestElement) {
            this.parameterName = parameterName;
            this.requestElement = requestElement;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public void setRequestElement(String requestElement) {
            this.requestElement = requestElement;
        }

        public String getRequestElement() {
            return this.requestElement;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public boolean isEdit() {
            return this.edit;
        }

        public void setEdit(boolean edit) {
            this.edit = edit;
        }

        public boolean isMarkedForDelete() {
            return this.markedForDelete;
        }

        public void setMarkedForDelete(boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
        }
    }
}

