/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.WsTrustRestrictByState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustListUIEntry;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

public class WsTrustRestrictBySubjectDnState
extends WsTrustRestrictByState {
    private static final long serialVersionUID = 2L;

    public WsTrustRestrictBySubjectDnState(Tasklet value) {
        super(value);
        this.setMenuName("Allowed Subject DNs");
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getListEntries() == null || this.getListEntries().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("At_least_one_subject_dn"), ValidationConstraint.REQUIRED);
        } else if (!this.hasAtLeastOneSubjectDn()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("At_least_one_subject_dn"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustStsData wsTrustData = (WsTrustStsData)dataToDisk;
        ArrayList<String> acceptableSubjectDnList = new ArrayList<String>();
        for (WsTrustListUIEntry entry : this.getListEntries()) {
            if (!entry.isActive()) continue;
            acceptableSubjectDnList.add(entry.getEntry());
        }
        wsTrustData.setAcceptableSubjectDnList(acceptableSubjectDnList);
        return true;
    }

    @Override
    protected void loadState(WsTrustStsData wsTrustData) {
        this.listEntries = this.getEntryList(wsTrustData.getAcceptableSubjectDnList());
    }

    private List<WsTrustListUIEntry> getEntryList(List<String> entries) {
        ArrayList<WsTrustListUIEntry> tempList = new ArrayList<WsTrustListUIEntry>();
        for (String entry : entries) {
            WsTrustListUIEntry temp = new WsTrustListUIEntry();
            temp.setEntry(entry);
            tempList.add(temp);
        }
        return tempList;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getListEntries() != null && !this.getListEntries().isEmpty()) {
            for (WsTrustListUIEntry entry : this.getListEntries()) {
                if (!entry.isActive()) continue;
                summaryList.add(new SummaryInfo("Subject DN", entry.getEntry(), this));
            }
        }
    }

    public boolean hasAtLeastOneSubjectDn() {
        for (WsTrustListUIEntry entry : this.getListEntries()) {
            if (!entry.isActive()) continue;
            return true;
        }
        return false;
    }

    public List<String> getSubjectDNsList() {
        ArrayList<String> subjectDNs = new ArrayList<String>();
        for (WsTrustListUIEntry entry : this.getListEntries()) {
            if (!entry.isActive()) continue;
            subjectDNs.add(entry.getEntry());
        }
        return subjectDNs;
    }
}

