/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import com.pingidentity.fsm.tasklet.impl.WsTrustStsSslAuthTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.Util;

public class WsTrustSelectSslTypeState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private boolean restrictBySubjectDn;
    private boolean restrictByIssuerCert;

    public WsTrustSelectSslTypeState(Tasklet value) {
        super(value);
        this.setMenuName("Authentication Options");
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        WsTrustStsData wsTrustData = (WsTrustStsData)dataFromDisk;
        this.restrictBySubjectDn = wsTrustData.isRestrictBySubjectDn();
        this.restrictByIssuerCert = wsTrustData.isRestrictByIssuerCert();
        return true;
    }

    @Override
    public void cancel(Object data) {
        this.populateAllStates(data);
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        WsTrustStsSslAuthTasklet t = (WsTrustStsSslAuthTasklet)this.getParent();
        if (this.restrictBySubjectDn) {
            t.setRestrictBySubjectDnBreadcrumbs();
        }
        if (this.restrictByIssuerCert) {
            t.setRestrictByIssuerCertBreadcrumb();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustStsData wsTrustData = (WsTrustStsData)dataToDisk;
        wsTrustData.setRestrictBySubjectDn(this.restrictBySubjectDn);
        wsTrustData.setRestrictByIssuerCert(this.restrictByIssuerCert);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Enable_subject_dn_summary"), Boolean.toString(this.restrictBySubjectDn), this));
        summaryList.add(new SummaryInfo(this.getMessage("Enable_issuer_cert_summary"), Boolean.toString(this.restrictByIssuerCert), this));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.restrictByIssuerCert && !this.restrictBySubjectDn) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Must_select_one"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean isRestrictBySubjectDn() {
        return this.restrictBySubjectDn;
    }

    public void setRestrictBySubjectDn(boolean restrictBySubjectDn) {
        this.restrictBySubjectDn = restrictBySubjectDn;
    }

    public boolean isRestrictByIssuerCert() {
        return this.restrictByIssuerCert;
    }

    public void setRestrictByIssuerCert(boolean restrictByIssuerCert) {
        this.restrictByIssuerCert = restrictByIssuerCert;
    }

    public String getAuthnOptionsStr() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.isRestrictBySubjectDn()) {
            l.add(this.getMessage("Enable_subject_dn_summary"));
        }
        if (this.isRestrictByIssuerCert()) {
            l.add(this.getMessage("Enable_issuer_cert_summary"));
        }
        if (!this.isRestrictBySubjectDn() && !this.isRestrictByIssuerCert()) {
            l.add("None");
        }
        return Util.listToCommaDelimString(l);
    }
}

