/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGeneratorMappingTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;

public class WsTrustSelectTokenGeneratorDataSourceState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final String ADDITIONAL_VALUES = "ADDITIONAL_VALUES";
    private static final String TOKEN_ONLY = "TOKEN_ONLY";
    private List<String> attributeContractList;
    private String selectedDataSource = "TOKEN_ONLY";
    private boolean reconfigure = true;

    public WsTrustSelectTokenGeneratorDataSourceState(Tasklet value) {
        super(value);
        this.setMenuName("Attribute Retrieval");
    }

    @Override
    public void onStateActivated() {
        WsTrustTokenGeneratorMappingTasklet parentTasklet = (WsTrustTokenGeneratorMappingTasklet)this.getParent();
        this.attributeContractList = parentTasklet.getAttributeList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenPluginAttributeMapping attributeMappingFromDisk = (TokenPluginAttributeMapping)dataFromDisk;
        AttributeSource source = attributeMappingFromDisk.getAttributeMapping().getAttributeSource();
        this.selectedDataSource = source != null && !DataSource.DSType.None.getName().equalsIgnoreCase(source.getType()) ? ADDITIONAL_VALUES : TOKEN_ONLY;
        if (this.reconfigure) {
            this.reconfigure = false;
            this.getParent().reconfigureTransitions(this);
        }
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
            this.getParent().reconfigureTransitions(this);
        }
    }

    public String getSelectedDataSource() {
        return this.selectedDataSource;
    }

    public void setSelectedDataSource(String selectedDataSource) {
        if (!this.selectedDataSource.equals(selectedDataSource)) {
            this.selectedDataSource = selectedDataSource;
            this.getParent().reconfigureTransitions(this);
        }
    }

    public boolean includeAdditionalValues() {
        return ADDITIONAL_VALUES.equals(this.selectedDataSource);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedDataSource.equals(ADDITIONAL_VALUES)) {
            summaryList.add(new SummaryInfo("Attribute location", this.getMessage("Lookup_info"), this));
        } else {
            summaryList.add(new SummaryInfo("Attribute location", this.getMessage("Token_only"), this));
        }
    }

    public List<String> getAttributeContractList() {
        return this.attributeContractList;
    }

    public void setAttributeContractList(List<String> attributeContractList) {
        this.attributeContractList = attributeContractList;
    }
}

